/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.DTrace;
import com.db4o.foundation.No4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.Indexable4;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeAdd;
import com.db4o.internal.btree.BTreeCancelledRemoval;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePatch;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRemove;
import com.db4o.internal.btree.BTreeUpdate;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.btree.Searcher;

public final class BTreeNode
extends PersistentBase {
    private static final int COUNT_LEAF_AND_3_LINK_LENGTH = 17;
    private static final int SLOT_LEADING_LENGTH = 17;
    final BTree _btree;
    private int _count;
    private boolean _isLeaf;
    private Object[] _keys;
    private Object[] _children;
    private int _parentID;
    private int _previousID;
    private int _nextID;
    private boolean _cached;
    private boolean _dead;

    public BTreeNode(BTree btree, int count, boolean isLeaf, int parentID, int previousID, int nextID) {
        this._btree = btree;
        this._parentID = parentID;
        this._previousID = previousID;
        this._nextID = nextID;
        this._count = count;
        this._isLeaf = isLeaf;
        this.prepareArrays();
    }

    public BTreeNode(int id, BTree btree) {
        this._btree = btree;
        this.setID(id);
        this.setStateDeactivated();
    }

    public BTreeNode(Transaction trans, BTreeNode firstChild, BTreeNode secondChild) {
        this(firstChild._btree, 2, false, 0, 0, 0);
        this._keys[0] = firstChild._keys[0];
        this._children[0] = firstChild;
        this._keys[1] = secondChild._keys[0];
        this._children[1] = secondChild;
        this.write(trans.systemTransaction());
        firstChild.setParentID(trans, this.getID());
        secondChild.setParentID(trans, this.getID());
    }

    public BTree btree() {
        return this._btree;
    }

    public BTreeNode add(Transaction trans, PreparedComparison preparedComparison, Object obj) {
        ByteArrayBuffer reader = this.prepareRead(trans);
        Searcher s = this.search(preparedComparison, reader);
        if (this._isLeaf) {
            this.prepareWrite(trans);
            if (this.wasRemoved(trans, s)) {
                this.cancelRemoval(trans, obj, s.cursor());
                return null;
            }
            if (s.count() > 0 && !s.beforeFirst()) {
                s.moveForward();
            }
            this.prepareInsert(s.cursor());
            this._keys[s.cursor()] = this.applyNewAddPatch(trans, obj);
        } else {
            BTreeNode childNode = this.child(reader, s.cursor());
            BTreeNode childNodeOrSplit = childNode.add(trans, preparedComparison, obj);
            if (childNodeOrSplit == null) {
                return null;
            }
            this.prepareWrite(trans);
            this._keys[s.cursor()] = childNode._keys[0];
            if (childNode != childNodeOrSplit) {
                int splitCursor = s.cursor() + 1;
                this.prepareInsert(splitCursor);
                this._keys[splitCursor] = childNodeOrSplit._keys[0];
                this._children[splitCursor] = childNodeOrSplit;
            }
        }
        if (this.mustSplit()) {
            return this.split(trans);
        }
        if (s.cursor() == 0) {
            return this;
        }
        return null;
    }

    private boolean mustSplit() {
        return this._count >= this._btree.nodeSize();
    }

    private BTreeAdd applyNewAddPatch(Transaction trans, Object obj) {
        this.sizeIncrement(trans);
        return new BTreeAdd(trans, obj);
    }

    private void cancelRemoval(Transaction trans, Object obj, int index) {
        BTreeUpdate patch = (BTreeUpdate)this.keyPatch(index);
        BTreeUpdate nextPatch = patch.removeFor(trans);
        this._keys[index] = this.newCancelledRemoval(trans, patch.getObject(), obj, nextPatch);
        this.sizeIncrement(trans);
    }

    private BTreePatch newCancelledRemoval(Transaction trans, Object originalObject, Object currentObject, BTreeUpdate existingPatches) {
        return new BTreeCancelledRemoval(trans, originalObject, currentObject, existingPatches);
    }

    private void sizeIncrement(Transaction trans) {
        this._btree.sizeChanged(trans, this, 1);
    }

    private boolean wasRemoved(Transaction trans, Searcher s) {
        if (!s.foundMatch()) {
            return false;
        }
        BTreePatch patch = this.keyPatch(trans, s.cursor());
        return patch != null && patch.isRemove();
    }

    BTreeNodeSearchResult searchLeaf(Transaction trans, PreparedComparison preparedComparison, SearchTarget target) {
        ByteArrayBuffer reader = this.prepareRead(trans);
        Searcher s = this.search(preparedComparison, reader, target);
        if (!this._isLeaf) {
            return this.child(reader, s.cursor()).searchLeaf(trans, preparedComparison, target);
        }
        if (!s.foundMatch() || target == SearchTarget.ANY || target == SearchTarget.HIGHEST) {
            return new BTreeNodeSearchResult(trans, reader, this.btree(), s, this);
        }
        if (target == SearchTarget.LOWEST) {
            BTreeNodeSearchResult res = this.findLowestLeafMatch(trans, preparedComparison, s.cursor() - 1);
            if (res != null) {
                return res;
            }
            return this.createMatchingSearchResult(trans, reader, s.cursor());
        }
        throw new IllegalStateException();
    }

    private BTreeNodeSearchResult findLowestLeafMatch(Transaction trans, PreparedComparison preparedComparison, int index) {
        return this.findLowestLeafMatch(trans, preparedComparison, this.prepareRead(trans), index);
    }

    private BTreeNodeSearchResult findLowestLeafMatch(Transaction trans, PreparedComparison preparedComparison, ByteArrayBuffer reader, int index) {
        ByteArrayBuffer nodeReader;
        BTreeNodeSearchResult res;
        BTreeNode node;
        if (index >= 0) {
            if (!this.compareEquals(preparedComparison, reader, index)) {
                return null;
            }
            if (index > 0) {
                BTreeNodeSearchResult res2 = this.findLowestLeafMatch(trans, preparedComparison, reader, index - 1);
                if (res2 != null) {
                    return res2;
                }
                return this.createMatchingSearchResult(trans, reader, index);
            }
        }
        if ((node = this.previousNode()) != null && (res = node.findLowestLeafMatch(trans, preparedComparison, nodeReader = node.prepareRead(trans), node.lastIndex())) != null) {
            return res;
        }
        if (index < 0) {
            return null;
        }
        return this.createMatchingSearchResult(trans, reader, index);
    }

    private boolean compareEquals(PreparedComparison preparedComparison, ByteArrayBuffer reader, int index) {
        if (this.canWrite()) {
            return this.compareInWriteMode(preparedComparison, index) == 0;
        }
        return this.compareInReadMode(preparedComparison, reader, index) == 0;
    }

    private BTreeNodeSearchResult createMatchingSearchResult(Transaction trans, ByteArrayBuffer reader, int index) {
        return new BTreeNodeSearchResult(trans, reader, this.btree(), this, index, true);
    }

    public boolean canWrite() {
        return this._keys != null;
    }

    BTreeNode child(int index) {
        if (this._children[index] instanceof BTreeNode) {
            return (BTreeNode)this._children[index];
        }
        return this._btree.produceNode((Integer)this._children[index]);
    }

    BTreeNode child(ByteArrayBuffer reader, int index) {
        if (this.childLoaded(index)) {
            return (BTreeNode)this._children[index];
        }
        BTreeNode child = this._btree.produceNode(this.childID(reader, index));
        if (this._children != null && (this._cached || child.canWrite())) {
            this._children[index] = child;
        }
        return child;
    }

    private int childID(ByteArrayBuffer reader, int index) {
        if (this._children == null) {
            this.seekChild(reader, index);
            return reader.readInt();
        }
        return this.childID(index);
    }

    private int childID(int index) {
        if (this.childLoaded(index)) {
            return ((BTreeNode)this._children[index]).getID();
        }
        return (Integer)this._children[index];
    }

    private boolean childLoaded(int index) {
        if (this._children == null) {
            return false;
        }
        return this._children[index] instanceof BTreeNode;
    }

    private boolean childCanSupplyFirstKey(int index) {
        if (!this.childLoaded(index)) {
            return false;
        }
        return ((BTreeNode)this._children[index]).canWrite();
    }

    public void commit(Transaction trans) {
        this.commitOrRollback(trans, true);
    }

    void commitOrRollback(Transaction trans, boolean isCommit) {
        if (DTrace.enabled) {
            DTrace.BTREE_NODE_COMMIT_OR_ROLLBACK.log(this.getID());
        }
        if (this._dead) {
            return;
        }
        this._cached = false;
        if (!this._isLeaf) {
            return;
        }
        if (!this.isDirty(trans)) {
            return;
        }
        Object keyZero = this._keys[0];
        Object[] tempKeys = new Object[this._btree.nodeSize()];
        int count = 0;
        for (int i = 0; i < this._count; ++i) {
            Object key = this._keys[i];
            BTreePatch patch = this.keyPatch(i);
            if (patch != null) {
                Object object = key = isCommit ? patch.commit(trans, this._btree, this) : patch.rollback(trans, this._btree);
            }
            if (key == No4.INSTANCE) continue;
            tempKeys[count] = key;
            ++count;
        }
        this._keys = tempKeys;
        this._count = count;
        if (this.freeIfEmpty(trans)) {
            return;
        }
        this.setStateDirty();
        if (this._keys[0] != keyZero) {
            this.tellParentAboutChangedKey(trans);
        }
    }

    private boolean freeIfEmpty(Transaction trans) {
        return this.freeIfEmpty(trans, this._count);
    }

    private boolean freeIfEmpty(Transaction trans, int count) {
        if (count > 0) {
            return false;
        }
        if (this.isRoot()) {
            return false;
        }
        this.free(trans);
        return true;
    }

    private boolean isRoot() {
        return this._btree.root() == this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BTreeNode)) {
            return false;
        }
        BTreeNode other = (BTreeNode)obj;
        return this.getID() == other.getID();
    }

    public int hashCode() {
        return this.getID();
    }

    public void free(Transaction trans) {
        this._dead = true;
        if (!this.isRoot()) {
            BTreeNode parent = this._btree.produceNode(this._parentID);
            parent.removeChild(trans, this);
        }
        this.pointPreviousTo(trans, this._nextID);
        this.pointNextTo(trans, this._previousID);
        super.free(trans);
        this._btree.removeNode(this);
        this._btree.notifyDeleted(trans, this);
    }

    void holdChildrenAsIDs() {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._children[i] instanceof BTreeNode)) continue;
            this._children[i] = new Integer(((BTreeNode)this._children[i]).getID());
        }
    }

    private void removeChild(Transaction trans, BTreeNode child) {
        this.prepareWrite(trans);
        int id = child.getID();
        for (int i = 0; i < this._count; ++i) {
            if (this.childID(i) != id) continue;
            if (this.freeIfEmpty(trans, this._count - 1)) {
                return;
            }
            this.remove(i);
            if (i <= 1) {
                this.tellParentAboutChangedKey(trans);
            }
            if (this._count == 0) {
                this._isLeaf = true;
            }
            return;
        }
        throw new IllegalStateException("child not found");
    }

    private void keyChanged(Transaction trans, BTreeNode child) {
        this.prepareWrite(trans);
        int id = child.getID();
        for (int i = 0; i < this._count; ++i) {
            if (this.childID(i) != id) continue;
            this._keys[i] = child._keys[0];
            this._children[i] = child;
            this.keyChanged(trans, i);
            return;
        }
        throw new IllegalStateException("child not found");
    }

    private void tellParentAboutChangedKey(Transaction trans) {
        if (!this.isRoot()) {
            BTreeNode parent = this._btree.produceNode(this._parentID);
            parent.keyChanged(trans, this);
        }
    }

    private boolean isDirty(Transaction trans) {
        if (!this.canWrite()) {
            return false;
        }
        for (int i = 0; i < this._count; ++i) {
            if (this.keyPatch(trans, i) == null) continue;
            return true;
        }
        return false;
    }

    private int compareInWriteMode(PreparedComparison preparedComparison, int index) {
        return -preparedComparison.compareTo(this.key(index));
    }

    private int compareInReadMode(PreparedComparison preparedComparison, ByteArrayBuffer reader, int index) {
        this.seekKey(reader, index);
        return -preparedComparison.compareTo(this.keyHandler().readIndexEntry(reader));
    }

    public int count() {
        return this._count;
    }

    private int entryLength() {
        int len = this.keyHandler().linkLength();
        if (!this._isLeaf) {
            len += 4;
        }
        return len;
    }

    public int firstKeyIndex(Transaction trans) {
        for (int ix = 0; ix < this._count; ++ix) {
            if (!this.indexIsValid(trans, ix)) continue;
            return ix;
        }
        return -1;
    }

    public int lastKeyIndex(Transaction trans) {
        for (int ix = this._count - 1; ix >= 0; --ix) {
            if (!this.indexIsValid(trans, ix)) continue;
            return ix;
        }
        return -1;
    }

    public boolean indexIsValid(Transaction trans, int index) {
        if (!this.canWrite()) {
            return true;
        }
        BTreePatch patch = this.keyPatch(index);
        if (patch == null) {
            return true;
        }
        return patch.key(trans) != No4.INSTANCE;
    }

    private Object firstKey(Transaction trans) {
        int index = this.firstKeyIndex(trans);
        if (-1 == index) {
            return No4.INSTANCE;
        }
        return this.internalKey(trans, index);
    }

    public byte getIdentifier() {
        return 66;
    }

    private void prepareInsert(int pos) {
        if (pos > this.lastIndex()) {
            ++this._count;
            return;
        }
        int len = this._count - pos;
        System.arraycopy(this._keys, pos, this._keys, pos + 1, len);
        if (this._children != null) {
            System.arraycopy(this._children, pos, this._children, pos + 1, len);
        }
        ++this._count;
    }

    private void remove(int pos) {
        if (DTrace.enabled) {
            DTrace.BTREE_NODE_REMOVE.log(this.getID());
        }
        int len = this._count - pos;
        --this._count;
        System.arraycopy(this._keys, pos + 1, this._keys, pos, len);
        this._keys[this._count] = null;
        if (this._children != null) {
            System.arraycopy(this._children, pos + 1, this._children, pos, len);
            this._children[this._count] = null;
        }
    }

    Object key(int index) {
        Object obj = this._keys[index];
        if (obj instanceof BTreePatch) {
            return ((BTreePatch)obj).getObject();
        }
        return obj;
    }

    public Object key(Transaction trans, int index) {
        return this.key(trans, this.prepareRead(trans), index);
    }

    Object key(Transaction trans, ByteArrayBuffer reader, int index) {
        if (this.canWrite()) {
            return this.internalKey(trans, index);
        }
        this.seekKey(reader, index);
        return this.keyHandler().readIndexEntry(reader);
    }

    private Object internalKey(Transaction trans, int index) {
        BTreePatch patch = this.keyPatch(index);
        if (patch == null) {
            return this._keys[index];
        }
        return patch.key(trans);
    }

    private BTreePatch keyPatch(int index) {
        Object obj = this._keys[index];
        if (obj instanceof BTreePatch) {
            return (BTreePatch)obj;
        }
        return null;
    }

    BTreePatch keyPatch(Transaction trans, int index) {
        Object obj = this._keys[index];
        if (obj instanceof BTreePatch) {
            return ((BTreePatch)obj).forTransaction(trans);
        }
        return null;
    }

    private Indexable4 keyHandler() {
        return this._btree.keyHandler();
    }

    void markAsCached(int height) {
        throw new NotImplementedException();
    }

    public int ownLength() {
        return 17 + this._count * this.entryLength() + 0;
    }

    ByteArrayBuffer prepareRead(Transaction trans) {
        if (this.canWrite()) {
            return null;
        }
        if (this.isNew()) {
            return null;
        }
        if (this._cached) {
            this.read(trans.systemTransaction());
            this._btree.addToProcessing(this);
            return null;
        }
        ByteArrayBuffer reader = ((LocalTransaction)trans).file().readReaderByID(trans.systemTransaction(), this.getID());
        this.readNodeHeader(reader);
        return reader;
    }

    void prepareWrite(Transaction trans) {
        if (this._dead) {
            return;
        }
        if (this.canWrite()) {
            this.setStateDirty();
            return;
        }
        this.read(trans.systemTransaction());
        this.setStateDirty();
        this._btree.addToProcessing(this);
    }

    private void prepareArrays() {
        if (this.canWrite()) {
            return;
        }
        this._keys = new Object[this._btree.nodeSize()];
        if (!this._isLeaf) {
            this._children = new Object[this._btree.nodeSize()];
        }
    }

    private void readNodeHeader(ByteArrayBuffer reader) {
        this._count = reader.readInt();
        byte leafByte = reader.readByte();
        this._isLeaf = leafByte == 1;
        this._parentID = reader.readInt();
        this._previousID = reader.readInt();
        this._nextID = reader.readInt();
    }

    public void readThis(Transaction trans, ByteArrayBuffer reader) {
        this.readNodeHeader(reader);
        this.prepareArrays();
        boolean isInner = !this._isLeaf;
        for (int i = 0; i < this._count; ++i) {
            this._keys[i] = this.keyHandler().readIndexEntry(reader);
            if (!isInner) continue;
            this._children[i] = new Integer(reader.readInt());
        }
    }

    public void remove(Transaction trans, int index) {
        BTreePatch transPatch;
        if (!this._isLeaf) {
            throw new IllegalStateException();
        }
        this.prepareWrite(trans);
        Object obj = null;
        BTreePatch patch = this.keyPatch(index);
        obj = patch == null ? this._keys[index] : ((transPatch = patch.forTransaction(trans)) != null ? transPatch.getObject() : patch.getObject());
        this.remove(trans, obj, index);
    }

    public boolean remove(Transaction trans, Object obj, int index) {
        if (!this._isLeaf) {
            throw new IllegalStateException();
        }
        this.prepareWrite(trans);
        BTreePatch patch = this.keyPatch(index);
        if (patch == null) {
            this._keys[index] = this.applyNewRemovePatch(trans, obj);
            this.keyChanged(trans, index);
            return true;
        }
        BTreePatch transPatch = patch.forTransaction(trans);
        if (transPatch != null) {
            if (transPatch.isAdd()) {
                this.cancelAdding(trans, index);
                return true;
            }
            if (transPatch.isCancelledRemoval()) {
                BTreeRemove removePatch = this.applyNewRemovePatch(trans, transPatch.getObject());
                this._keys[index] = ((BTreeUpdate)patch).replacePatch(transPatch, removePatch);
                this.keyChanged(trans, index);
                return true;
            }
        } else if (!patch.isAdd()) {
            ((BTreeUpdate)patch).append(this.applyNewRemovePatch(trans, obj));
            return true;
        }
        return false;
    }

    public void remove(Transaction trans, PreparedComparison preparedComparison, Object obj, int index) {
        if (this.remove(trans, obj, index)) {
            return;
        }
        if (index != this.lastIndex()) {
            if (this.compareInWriteMode(preparedComparison, index + 1) != 0) {
                return;
            }
            this.remove(trans, preparedComparison, obj, index + 1);
            return;
        }
        BTreeNode node = this.nextNode();
        if (node == null) {
            return;
        }
        node.prepareWrite(trans);
        if (node.compareInWriteMode(preparedComparison, 0) != 0) {
            return;
        }
        node.remove(trans, preparedComparison, obj, 0);
    }

    private void cancelAdding(Transaction trans, int index) {
        this._btree.notifyRemoveListener(this.keyPatch(index).getObject());
        if (this.freeIfEmpty(trans, this._count - 1)) {
            this.sizeDecrement(trans);
            return;
        }
        this.remove(index);
        this.keyChanged(trans, index);
        this.sizeDecrement(trans);
    }

    private void sizeDecrement(Transaction trans) {
        this._btree.sizeChanged(trans, this, -1);
    }

    private int lastIndex() {
        return this._count - 1;
    }

    private BTreeRemove applyNewRemovePatch(Transaction trans, Object key) {
        this.sizeDecrement(trans);
        return new BTreeRemove(trans, key);
    }

    private void keyChanged(Transaction trans, int index) {
        if (index == 0) {
            this.tellParentAboutChangedKey(trans);
        }
    }

    void rollback(Transaction trans) {
        this.commitOrRollback(trans, false);
    }

    private Searcher search(PreparedComparison preparedComparison, ByteArrayBuffer reader) {
        return this.search(preparedComparison, reader, SearchTarget.ANY);
    }

    private Searcher search(PreparedComparison preparedComparison, ByteArrayBuffer reader, SearchTarget target) {
        Searcher s = new Searcher(target, this._count);
        if (this.canWrite()) {
            while (s.incomplete()) {
                s.resultIs(this.compareInWriteMode(preparedComparison, s.cursor()));
            }
        } else {
            while (s.incomplete()) {
                s.resultIs(this.compareInReadMode(preparedComparison, reader, s.cursor()));
            }
        }
        return s;
    }

    private void seekAfterKey(ByteArrayBuffer reader, int ix) {
        this.seekKey(reader, ix);
        reader._offset += this.keyHandler().linkLength();
    }

    private void seekChild(ByteArrayBuffer reader, int ix) {
        this.seekAfterKey(reader, ix);
    }

    private void seekKey(ByteArrayBuffer reader, int ix) {
        reader._offset = 17 + this.entryLength() * ix;
    }

    private BTreeNode split(Transaction trans) {
        int i;
        BTreeNode res = new BTreeNode(this._btree, this._btree._halfNodeSize, this._isLeaf, this._parentID, this.getID(), this._nextID);
        System.arraycopy(this._keys, this._btree._halfNodeSize, res._keys, 0, this._btree._halfNodeSize);
        for (i = this._btree._halfNodeSize; i < this._keys.length; ++i) {
            this._keys[i] = null;
        }
        if (this._children != null) {
            res._children = new Object[this._btree.nodeSize()];
            System.arraycopy(this._children, this._btree._halfNodeSize, res._children, 0, this._btree._halfNodeSize);
            for (i = this._btree._halfNodeSize; i < this._children.length; ++i) {
                this._children[i] = null;
            }
        }
        this._count = this._btree._halfNodeSize;
        res.write(trans.systemTransaction());
        this._btree.addNode(res);
        int splitID = res.getID();
        this.pointNextTo(trans, splitID);
        this.setNextID(trans, splitID);
        if (this._children != null) {
            for (int i2 = 0; i2 < this._btree._halfNodeSize && res._children[i2] != null; ++i2) {
                res.child(i2).setParentID(trans, splitID);
            }
        }
        this._btree.notifySplit(trans, this, res);
        return res;
    }

    private void pointNextTo(Transaction trans, int id) {
        if (this._nextID != 0) {
            this.nextNode().setPreviousID(trans, id);
        }
    }

    private void pointPreviousTo(Transaction trans, int id) {
        if (this._previousID != 0) {
            this.previousNode().setNextID(trans, id);
        }
    }

    public BTreeNode previousNode() {
        if (this._previousID == 0) {
            return null;
        }
        return this._btree.produceNode(this._previousID);
    }

    public BTreeNode nextNode() {
        if (this._nextID == 0) {
            return null;
        }
        return this._btree.produceNode(this._nextID);
    }

    BTreePointer firstPointer(Transaction trans) {
        ByteArrayBuffer reader = this.prepareRead(trans);
        if (this._isLeaf) {
            return this.leafFirstPointer(trans, reader);
        }
        return this.branchFirstPointer(trans, reader);
    }

    private BTreePointer branchFirstPointer(Transaction trans, ByteArrayBuffer reader) {
        for (int i = 0; i < this._count; ++i) {
            BTreePointer childFirstPointer = this.child(reader, i).firstPointer(trans);
            if (childFirstPointer == null) continue;
            return childFirstPointer;
        }
        return null;
    }

    private BTreePointer leafFirstPointer(Transaction trans, ByteArrayBuffer reader) {
        int index = this.firstKeyIndex(trans);
        if (index == -1) {
            return null;
        }
        return new BTreePointer(trans, reader, this, index);
    }

    public BTreePointer lastPointer(Transaction trans) {
        ByteArrayBuffer reader = this.prepareRead(trans);
        if (this._isLeaf) {
            return this.leafLastPointer(trans, reader);
        }
        return this.branchLastPointer(trans, reader);
    }

    private BTreePointer branchLastPointer(Transaction trans, ByteArrayBuffer reader) {
        for (int i = this._count - 1; i >= 0; --i) {
            BTreePointer childLastPointer = this.child(reader, i).lastPointer(trans);
            if (childLastPointer == null) continue;
            return childLastPointer;
        }
        return null;
    }

    private BTreePointer leafLastPointer(Transaction trans, ByteArrayBuffer reader) {
        int index = this.lastKeyIndex(trans);
        if (index == -1) {
            return null;
        }
        return new BTreePointer(trans, reader, this, index);
    }

    public void purge() {
        if (this._dead) {
            this._keys = null;
            this._children = null;
            return;
        }
        if (this._cached) {
            return;
        }
        if (!this.canWrite()) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._keys[i] instanceof BTreePatch)) continue;
            this.holdChildrenAsIDs();
            this._btree.addNode(this);
            return;
        }
    }

    private void setParentID(Transaction trans, int id) {
        this.prepareWrite(trans);
        this._parentID = id;
    }

    private void setPreviousID(Transaction trans, int id) {
        this.prepareWrite(trans);
        this._previousID = id;
    }

    private void setNextID(Transaction trans, int id) {
        this.prepareWrite(trans);
        this._nextID = id;
    }

    public void traverseKeys(Transaction trans, Visitor4 visitor) {
        ByteArrayBuffer reader = this.prepareRead(trans);
        if (this._isLeaf) {
            for (int i = 0; i < this._count; ++i) {
                Object obj = this.key(trans, reader, i);
                if (obj == No4.INSTANCE) continue;
                visitor.visit(obj);
            }
        } else {
            for (int i = 0; i < this._count; ++i) {
                this.child(reader, i).traverseKeys(trans, visitor);
            }
        }
    }

    public boolean writeObjectBegin() {
        if (this._dead) {
            return false;
        }
        if (!this.canWrite()) {
            return false;
        }
        return super.writeObjectBegin();
    }

    public void writeThis(Transaction trans, ByteArrayBuffer a_writer) {
        int i;
        int count = 0;
        int startOffset = a_writer._offset;
        a_writer.incrementOffset(17);
        if (this._isLeaf) {
            for (i = 0; i < this._count; ++i) {
                Object obj = this.internalKey(trans, i);
                if (obj == No4.INSTANCE) continue;
                ++count;
                this.keyHandler().writeIndexEntry(a_writer, obj);
            }
        } else {
            for (i = 0; i < this._count; ++i) {
                if (this.childCanSupplyFirstKey(i)) {
                    BTreeNode child = (BTreeNode)this._children[i];
                    Object childKey = child.firstKey(trans);
                    if (childKey == No4.INSTANCE) continue;
                    ++count;
                    this.keyHandler().writeIndexEntry(a_writer, childKey);
                    a_writer.writeIDOf(trans, child);
                    continue;
                }
                ++count;
                this.keyHandler().writeIndexEntry(a_writer, this.key(i));
                a_writer.writeIDOf(trans, this._children[i]);
            }
        }
        int endOffset = a_writer._offset;
        a_writer._offset = startOffset;
        a_writer.writeInt(count);
        a_writer.writeByte(this._isLeaf ? (byte)1 : 0);
        a_writer.writeInt(this._parentID);
        a_writer.writeInt(this._previousID);
        a_writer.writeInt(this._nextID);
        a_writer._offset = endOffset;
    }

    public String toString() {
        if (this._count == 0) {
            return "Node " + this.getID() + " not loaded";
        }
        String str = "\nBTreeNode";
        str = str + "\nid: " + this.getID();
        str = str + "\nparent: " + this._parentID;
        str = str + "\nprevious: " + this._previousID;
        str = str + "\nnext: " + this._nextID;
        str = str + "\ncount:" + this._count;
        str = str + "\nleaf:" + this._isLeaf + "\n";
        if (this.canWrite()) {
            str = str + " { ";
            boolean first = true;
            for (int i = 0; i < this._count; ++i) {
                if (this._keys[i] == null) continue;
                if (!first) {
                    str = str + ", ";
                }
                str = str + this._keys[i].toString();
                first = false;
            }
            str = str + " }";
        }
        return str;
    }

    public void debugLoadFully(Transaction trans) {
        this.prepareWrite(trans);
        if (this._isLeaf) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (this._children[i] instanceof Integer) {
                this._children[i] = this.btree().produceNode((Integer)this._children[i]);
            }
            ((BTreeNode)this._children[i]).debugLoadFully(trans);
        }
    }

    public static void defragIndex(DefragmentContextImpl context, Indexable4 keyHandler) {
        int count = context.readInt();
        byte leafByte = context.readByte();
        boolean isLeaf = leafByte == 1;
        context.copyID();
        context.copyID();
        context.copyID();
        for (int i = 0; i < count; ++i) {
            keyHandler.defragIndexEntry(context);
            if (isLeaf) continue;
            context.copyID();
        }
    }

    public boolean isFreespaceComponent() {
        return this._btree.isFreespaceComponent();
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void traverseAllNodes(Transaction trans, Visitor4 command) {
        ByteArrayBuffer reader = this.prepareRead(trans);
        command.visit(this);
        if (this._isLeaf) {
            return;
        }
        for (int childIdx = 0; childIdx < this._count; ++childIdx) {
            this.child(reader, childIdx).traverseAllNodes(trans, command);
        }
    }

    public int size(Transaction trans) {
        this.prepareRead(trans);
        if (!this.canWrite()) {
            return this._count;
        }
        int size = 0;
        for (int i = 0; i < this._count; ++i) {
            BTreePatch keyPatch = this.keyPatch(i);
            if (keyPatch != null) {
                size += keyPatch.sizeDiff(trans);
                continue;
            }
            ++size;
        }
        return size;
    }
}

