/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.BlobTransport;
import com.db4o.DTrace;
import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.ExtClient;
import com.db4o.ext.InvalidPasswordException;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.BlockingQueueStoppedException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.NotSupportedException;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Serializer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.cs.BlobProcessor;
import com.db4o.internal.cs.ClassInfo;
import com.db4o.internal.cs.ClassInfoHelper;
import com.db4o.internal.cs.ClientAsynchronousMessageProcessor;
import com.db4o.internal.cs.ClientHeartbeat;
import com.db4o.internal.cs.ClientMessageDispatcher;
import com.db4o.internal.cs.ClientMessageDispatcherImpl;
import com.db4o.internal.cs.ClientQueryResult;
import com.db4o.internal.cs.ClientTransaction;
import com.db4o.internal.cs.LazyClientQueryResult;
import com.db4o.internal.cs.messages.ClientSideMessage;
import com.db4o.internal.cs.messages.MDeleteBlobFile;
import com.db4o.internal.cs.messages.MError;
import com.db4o.internal.cs.messages.MRuntimeException;
import com.db4o.internal.cs.messages.MUserMessage;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgBlob;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.cs.messages.MsgObject;
import com.db4o.internal.encoding.UnicodeStringIO;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.slots.Pointer4;
import com.db4o.reflect.ReflectClass;
import java.io.File;
import java.io.IOException;

public class ClientObjectContainer
extends ExternalObjectContainer
implements ExtClient,
BlobTransport,
ClientMessageDispatcher {
    final Object blobLock = new Object();
    private BlobProcessor blobThread;
    private Socket4 i_socket;
    private BlockingQueue _synchronousMessageQueue = new BlockingQueue();
    private BlockingQueue _asynchronousMessageQueue = new BlockingQueue();
    private final String _password;
    int[] _prefetchedIDs;
    ClientMessageDispatcher _messageDispatcher;
    ClientAsynchronousMessageProcessor _asynchronousMessageProcessor;
    int remainingIDs;
    private String switchedToFile;
    private boolean _singleThreaded;
    private final String _userName;
    private Db4oDatabase i_db;
    protected boolean _doFinalize = true;
    private int _blockSize = 1;
    private Collection4 _batchedMessages = new Collection4();
    private int _batchedQueueLength = 4;
    private boolean _login;
    private final ClientHeartbeat _heartbeat;
    private final ClassInfoHelper _classInfoHelper = new ClassInfoHelper();

    public ClientObjectContainer(Configuration config, Socket4 socket, String user, String password, boolean login) {
        super(config, null);
        this._userName = user;
        this._password = password;
        this._login = login;
        this._heartbeat = new ClientHeartbeat(this);
        this.setAndConfigSocket(socket);
        this.open();
    }

    private void setAndConfigSocket(Socket4 socket) {
        this.i_socket = socket;
        this.i_socket.setSoTimeout(this._config.timeoutClientSocket());
    }

    protected final void openImpl() {
        this._singleThreaded = this.configImpl().singleThreadedClient();
        if (this._login) {
            this.loginToServer(this.i_socket);
        }
        if (!this._singleThreaded) {
            this.startDispatcherThread(this.i_socket, this._userName);
        }
        this.logMsg(36, this.toString());
        this.startHeartBeat();
        this.readThis();
    }

    private void startHeartBeat() {
        this._heartbeat.start();
    }

    private void startDispatcherThread(Socket4 socket, String user) {
        if (!this._singleThreaded) {
            this._asynchronousMessageProcessor = new ClientAsynchronousMessageProcessor(this._asynchronousMessageQueue);
            this._asynchronousMessageProcessor.startProcessing();
        }
        this._messageDispatcher = new ClientMessageDispatcherImpl(this, socket, this._synchronousMessageQueue, this._asynchronousMessageQueue);
        this._messageDispatcher.setDispatcherName(user);
        this._messageDispatcher.startDispatcher();
    }

    public void backup(String path) throws NotSupportedException {
        throw new NotSupportedException();
    }

    public void reserve(int byteCount) {
        throw new NotSupportedException();
    }

    public void blockSize(int blockSize) {
        this._blockSize = blockSize;
    }

    public byte blockSize() {
        return (byte)this._blockSize;
    }

    protected void close2() {
        if (!(this._singleThreaded || this._messageDispatcher != null && this._messageDispatcher.isMessageDispatcherAlive())) {
            this.stopHeartBeat();
            this.shutdownObjectContainer();
            return;
        }
        try {
            this.commit1(this._transaction);
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        try {
            this.write(Msg.CLOSE);
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        this.shutDownCommunicationRessources();
        try {
            this.i_socket.close();
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        this.shutdownObjectContainer();
    }

    private void stopHeartBeat() {
        this._heartbeat.stop();
    }

    private void closeMessageDispatcher() {
        try {
            if (!this._singleThreaded) {
                this._messageDispatcher.close();
            }
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        try {
            if (!this._singleThreaded) {
                this._asynchronousMessageProcessor.stopProcessing();
            }
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
    }

    public final void commit1(Transaction trans) {
        trans.commit();
    }

    public int converterVersion() {
        return 7;
    }

    Socket4 createParalellSocket() throws IOException {
        this.write(Msg.GET_THREAD_ID);
        int serverThreadID = this.expectedByteResponse(Msg.ID_LIST).readInt();
        Socket4 sock = this.i_socket.openParalellSocket();
        this.loginToServer(sock);
        if (this.switchedToFile != null) {
            MsgD message = Msg.SWITCH_TO_FILE.getWriterForString(this.systemTransaction(), this.switchedToFile);
            message.write(sock);
            if (!Msg.OK.equals(Msg.readMessage(this, this.systemTransaction(), sock))) {
                throw new IOException(Messages.get(42));
            }
        }
        Msg.USE_TRANSACTION.getWriterForInt(this._transaction, serverThreadID).write(sock);
        return sock;
    }

    public AbstractQueryResult newQueryResult(Transaction trans, QueryEvaluationMode mode) {
        throw new IllegalStateException();
    }

    public final Transaction newTransaction(Transaction parentTransaction, TransactionalReferenceSystem referenceSystem) {
        return new ClientTransaction(this, parentTransaction, referenceSystem);
    }

    public boolean createClassMetadata(ClassMetadata clazz, ReflectClass claxx, ClassMetadata superClazz) {
        this.write(Msg.CREATE_CLASS.getWriterForString(this.systemTransaction(), this.config().resolveAliasRuntimeName(claxx.getName())));
        Msg resp = this.getResponse();
        if (resp == null) {
            return false;
        }
        if (resp.equals(Msg.FAILED)) {
            this.sendClassMeta(claxx);
            resp = this.getResponse();
        }
        if (resp.equals(Msg.FAILED)) {
            if (this.configImpl().exceptionsOnNotStorable()) {
                throw new ObjectNotStorableException(claxx);
            }
            return false;
        }
        if (!resp.equals(Msg.OBJECT_TO_CLIENT)) {
            return false;
        }
        MsgObject message = (MsgObject)resp;
        StatefulBuffer bytes = message.unmarshall();
        if (bytes == null) {
            return false;
        }
        bytes.setTransaction(this.systemTransaction());
        if (!super.createClassMetadata(clazz, claxx, superClazz)) {
            return false;
        }
        clazz.setID(message.getId());
        clazz.readName1(this.systemTransaction(), bytes);
        this.classCollection().addClassMetadata(clazz);
        this.classCollection().readClassMetadata(clazz, claxx);
        return true;
    }

    private void sendClassMeta(ReflectClass reflectClass) {
        ClassInfo classMeta = this._classInfoHelper.getClassMeta(reflectClass);
        this.write(Msg.CLASS_META.getWriter(Serializer.marshall(this.systemTransaction(), (Object)classMeta)));
    }

    public long currentVersion() {
        this.write(Msg.CURRENT_VERSION);
        return ((MsgD)this.expectedResponse(Msg.ID_LIST)).readLong();
    }

    public final boolean delete4(Transaction ta, ObjectReference yo, int a_cascade, boolean userCall) {
        MsgD msg = Msg.DELETE.getWriterForInts(this._transaction, new int[]{yo.getID(), userCall ? 1 : 0});
        this.writeBatchedMessage(msg);
        return true;
    }

    public boolean detectSchemaChanges() {
        return false;
    }

    protected boolean doFinalize() {
        return this._doFinalize;
    }

    final ByteArrayBuffer expectedByteResponse(Msg expectedMessage) {
        Msg msg = this.expectedResponse(expectedMessage);
        if (msg == null) {
            return null;
        }
        return msg.getByteLoad();
    }

    public final Msg expectedResponse(Msg expectedMessage) {
        Msg message = this.getResponse();
        if (expectedMessage.equals(message)) {
            return message;
        }
        this.checkExceptionMessage(message);
        throw new IllegalStateException("Unexpected Message:" + message + "  Expected:" + expectedMessage);
    }

    private void checkExceptionMessage(Msg msg) {
        if (msg instanceof MRuntimeException) {
            ((MRuntimeException)msg).throwPayload();
        }
    }

    public AbstractQueryResult queryAllObjects(Transaction trans) {
        int mode = this.config().queryEvaluationMode().asInt();
        MsgD msg = Msg.GET_ALL.getWriterForInt(trans, mode);
        this.write(msg);
        return this.readQueryResult(trans);
    }

    public Msg getResponse() {
        Msg msg;
        do {
            Msg msg2 = msg = this._singleThreaded ? this.getResponseSingleThreaded() : this.getResponseMultiThreaded();
        } while (this.isClientSideMessage(msg) && ((ClientSideMessage)((Object)msg)).processAtClient());
        return msg;
    }

    private Msg getResponseSingleThreaded() {
        while (this.isMessageDispatcherAlive()) {
            try {
                Msg message = Msg.readMessage(this, this._transaction, this.i_socket);
                if (this.isClientSideMessage(message) && ((ClientSideMessage)((Object)message)).processAtClient()) continue;
                return message;
            }
            catch (Db4oIOException exc) {
                this.onMsgError();
            }
        }
        return null;
    }

    private Msg getResponseMultiThreaded() {
        Msg msg;
        try {
            msg = (Msg)this._synchronousMessageQueue.next();
        }
        catch (BlockingQueueStoppedException e) {
            if (DTrace.enabled) {
                DTrace.BLOCKING_QUEUE_STOPPED_EXCEPTION.log(e.toString());
            }
            msg = Msg.ERROR;
        }
        if (msg instanceof MError) {
            this.onMsgError();
        }
        return msg;
    }

    private boolean isClientSideMessage(Msg message) {
        return message instanceof ClientSideMessage;
    }

    private void onMsgError() {
        this.close();
        throw new DatabaseClosedException();
    }

    public boolean isMessageDispatcherAlive() {
        return this.i_socket != null;
    }

    public ClassMetadata classMetadataForId(int clazzId) {
        ReflectClass claxx;
        if (clazzId == 0) {
            return null;
        }
        ClassMetadata yc = super.classMetadataForId(clazzId);
        if (yc != null) {
            return yc;
        }
        MsgD msg = Msg.CLASS_NAME_FOR_ID.getWriterForInt(this.systemTransaction(), clazzId);
        this.write(msg);
        MsgD message = (MsgD)this.expectedResponse(Msg.CLASS_NAME_FOR_ID);
        String className = this.config().resolveAliasStoredName(message.readString());
        if (className != null && className.length() > 0 && (claxx = this.reflector().forName(className)) != null) {
            return this.produceClassMetadata(claxx);
        }
        return null;
    }

    public boolean needsLockFileThread() {
        return false;
    }

    protected boolean hasShutDownHook() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oDatabase identity() {
        if (this.i_db == null) {
            this.write(Msg.IDENTITY);
            ByteArrayBuffer reader = this.expectedByteResponse(Msg.ID_LIST);
            this.showInternalClasses(true);
            try {
                this.i_db = (Db4oDatabase)this.getByID(reader.readInt());
                this.activate(this.systemTransaction(), this.i_db, new FixedActivationDepth(3));
            }
            finally {
                this.showInternalClasses(false);
            }
        }
        return this.i_db;
    }

    public boolean isClient() {
        return true;
    }

    private void loginToServer(Socket4 socket) throws InvalidPasswordException {
        UnicodeStringIO stringWriter = new UnicodeStringIO();
        int length = stringWriter.length(this._userName) + stringWriter.length(this._password);
        MsgD message = Msg.LOGIN.getWriterForLength(this.systemTransaction(), length);
        message.writeString(this._userName);
        message.writeString(this._password);
        message.write(socket);
        Msg msg = this.readLoginMessage(socket);
        StatefulBuffer payLoad = msg.payLoad();
        this._blockSize = payLoad.readInt();
        int doEncrypt = payLoad.readInt();
        if (doEncrypt == 0) {
            this._handlers.oldEncryptionOff();
        }
    }

    private Msg readLoginMessage(Socket4 socket) {
        Msg msg = Msg.readMessage(this, this.systemTransaction(), socket);
        while (Msg.PONG.equals(msg)) {
            msg = Msg.readMessage(this, this.systemTransaction(), socket);
        }
        if (!Msg.LOGIN_OK.equals(msg)) {
            throw new InvalidPasswordException();
        }
        return msg;
    }

    public boolean maintainsIndices() {
        return false;
    }

    public final int newUserObject() {
        int prefetchIDCount = this.config().prefetchIDCount();
        this.ensureIDCacheAllocated(prefetchIDCount);
        ByteArrayBuffer reader = null;
        if (this.remainingIDs < 1) {
            MsgD msg = Msg.PREFETCH_IDS.getWriterForInt(this._transaction, prefetchIDCount);
            this.write(msg);
            reader = this.expectedByteResponse(Msg.ID_LIST);
            for (int i = prefetchIDCount - 1; i >= 0; --i) {
                this._prefetchedIDs[i] = reader.readInt();
            }
            this.remainingIDs = prefetchIDCount;
        }
        --this.remainingIDs;
        return this._prefetchedIDs[this.remainingIDs];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBlobMessage(MsgBlob msg) {
        Object object = this.blobLock;
        synchronized (object) {
            boolean needStart;
            boolean bl = needStart = this.blobThread == null || this.blobThread.isTerminated();
            if (needStart) {
                this.blobThread = new BlobProcessor(this);
            }
            this.blobThread.add(msg);
            if (needStart) {
                this.blobThread.start();
            }
        }
    }

    public void raiseVersion(long a_minimumVersion) {
        this.write(Msg.RAISE_VERSION.getWriterForLong(this._transaction, a_minimumVersion));
    }

    public void readBytes(byte[] bytes, int address, int addressOffset, int length) {
        throw Exceptions4.virtualException();
    }

    public void readBytes(byte[] a_bytes, int a_address, int a_length) {
        MsgD msg = Msg.READ_BYTES.getWriterForInts(this._transaction, new int[]{a_address, a_length});
        this.write(msg);
        ByteArrayBuffer reader = this.expectedByteResponse(Msg.READ_BYTES);
        System.arraycopy(reader._buffer, 0, a_bytes, 0, a_length);
    }

    protected boolean rename1(Config4Impl config) {
        this.logMsg(58, null);
        return false;
    }

    public final StatefulBuffer readWriterByID(Transaction a_ta, int a_id) {
        return this.readWriterByID(a_ta, a_id, false);
    }

    public final StatefulBuffer readWriterByID(Transaction a_ta, int a_id, boolean lastCommitted) {
        MsgD msg = Msg.READ_OBJECT.getWriterForInts(a_ta, new int[]{a_id, lastCommitted ? 1 : 0});
        this.write(msg);
        StatefulBuffer bytes = ((MsgObject)this.expectedResponse(Msg.OBJECT_TO_CLIENT)).unmarshall();
        if (bytes != null) {
            bytes.setTransaction(a_ta);
        }
        return bytes;
    }

    public final StatefulBuffer[] readWritersByIDs(Transaction a_ta, int[] ids) {
        MsgD msg = Msg.READ_MULTIPLE_OBJECTS.getWriterForIntArray(a_ta, ids, ids.length);
        this.write(msg);
        MsgD response = (MsgD)this.expectedResponse(Msg.READ_MULTIPLE_OBJECTS);
        int count = response.readInt();
        StatefulBuffer[] yapWriters = new StatefulBuffer[count];
        for (int i = 0; i < count; ++i) {
            MsgObject mso = (MsgObject)Msg.OBJECT_TO_CLIENT.publicClone();
            mso.setTransaction(a_ta);
            mso.payLoad(response.payLoad().readYapBytes());
            if (mso.payLoad() == null) continue;
            mso.payLoad().incrementOffset(9);
            yapWriters[i] = mso.unmarshall(9);
            yapWriters[i].setTransaction(a_ta);
        }
        return yapWriters;
    }

    public final ByteArrayBuffer readReaderByID(Transaction a_ta, int a_id, boolean lastCommitted) {
        return this.readWriterByID(a_ta, a_id, lastCommitted);
    }

    public final ByteArrayBuffer readReaderByID(Transaction a_ta, int a_id) {
        return this.readReaderByID(a_ta, a_id, false);
    }

    private AbstractQueryResult readQueryResult(Transaction trans) {
        AbstractQueryResult queryResult = null;
        ByteArrayBuffer reader = this.expectedByteResponse(Msg.QUERY_RESULT);
        int queryResultID = reader.readInt();
        queryResult = queryResultID > 0 ? new LazyClientQueryResult(trans, this, queryResultID) : new ClientQueryResult(trans);
        ((AbstractQueryResult)queryResult).loadFromIdReader(reader);
        return queryResult;
    }

    void readThis() {
        this.write(Msg.GET_CLASSES.getWriter(this.systemTransaction()));
        ByteArrayBuffer bytes = this.expectedByteResponse(Msg.GET_CLASSES);
        this.classCollection().setID(bytes.readInt());
        this.createStringIO(bytes.readByte());
        this.classCollection().read(this.systemTransaction());
        this.classCollection().refreshClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphore(String name) {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            if (name == null) {
                throw new NullPointerException();
            }
            this.write(Msg.RELEASE_SEMAPHORE.getWriterForString(this._transaction, name));
        }
    }

    public void releaseSemaphores(Transaction ta) {
    }

    private void reReadAll(Configuration config) {
        this.remainingIDs = 0;
        this.initialize1(config);
        this.initializeTransactions();
        this.readThis();
    }

    public final void rollback1(Transaction trans) {
        if (this._config.batchMessages()) {
            this.clearBatchedObjects();
        }
        this.write(Msg.ROLLBACK);
        trans.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object obj) {
        Object object = this._lock;
        synchronized (object) {
            if (obj != null) {
                MUserMessage message = Msg.USER_MESSAGE;
                this.write(message.marshallUserMessage(this._transaction, obj));
            }
        }
    }

    public final void setDirtyInSystemTransaction(PersistentBase a_object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSemaphore(String name, int timeout) {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            if (name == null) {
                throw new NullPointerException();
            }
            MsgD msg = Msg.SET_SEMAPHORE.getWriterForIntString(this._transaction, timeout, name);
            this.write(msg);
            Msg message = this.getResponse();
            return message.equals(Msg.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToFile(String fileName) {
        Object object = this._lock;
        synchronized (object) {
            this.commit();
            MsgD msg = Msg.SWITCH_TO_FILE.getWriterForString(this._transaction, fileName);
            this.write(msg);
            this.expectedResponse(Msg.OK);
            this.reReadAll(Db4o.cloneConfiguration());
            this.switchedToFile = fileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMainFile() {
        Object object = this._lock;
        synchronized (object) {
            this.commit();
            this.write(Msg.SWITCH_TO_MAIN_FILE);
            this.expectedResponse(Msg.OK);
            this.reReadAll(Db4o.cloneConfiguration());
            this.switchedToFile = null;
        }
    }

    public String name() {
        return this.toString();
    }

    public String toString() {
        return "Client Connection " + this._userName;
    }

    public void shutdown() {
    }

    public final void writeDirty() {
    }

    public final boolean write(Msg msg) {
        this.writeMsg(msg, true);
        return true;
    }

    public final void writeBatchedMessage(Msg msg) {
        this.writeMsg(msg, false);
    }

    private final void writeMsg(Msg msg, boolean flush) {
        if (this._config.batchMessages()) {
            if (flush && this._batchedMessages.isEmpty()) {
                this.writeMessageToSocket(msg);
            } else {
                this.addToBatch(msg);
                if (flush || this._batchedQueueLength > this._config.maxBatchQueueSize()) {
                    this.writeBatchedMessages();
                }
            }
        } else {
            this.writeMessageToSocket(msg);
        }
    }

    public boolean writeMessageToSocket(Msg msg) {
        return msg.write(this.i_socket);
    }

    public final void writeNew(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ByteArrayBuffer buffer) {
        MsgD msg = Msg.WRITE_NEW.getWriter(trans, pointer, classMetadata, buffer);
        this.writeBatchedMessage(msg);
    }

    public final void writeTransactionPointer(int a_address) {
    }

    public final void writeUpdate(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ByteArrayBuffer buffer) {
        MsgD msg = Msg.WRITE_UPDATE.getWriter(trans, pointer, classMetadata, buffer);
        this.writeBatchedMessage(msg);
    }

    public boolean isAlive() {
        try {
            this.write(Msg.IS_ALIVE);
            return this.expectedResponse(Msg.IS_ALIVE) != null;
        }
        catch (Db4oException exc) {
            return false;
        }
    }

    public Socket4 socket() {
        return this.i_socket;
    }

    private void ensureIDCacheAllocated(int prefetchIDCount) {
        if (this._prefetchedIDs == null) {
            this._prefetchedIDs = new int[prefetchIDCount];
            return;
        }
        if (prefetchIDCount > this._prefetchedIDs.length) {
            int[] newPrefetchedIDs = new int[prefetchIDCount];
            System.arraycopy(this._prefetchedIDs, 0, newPrefetchedIDs, 0, this._prefetchedIDs.length);
            this._prefetchedIDs = newPrefetchedIDs;
        }
    }

    public SystemInfo systemInfo() {
        throw new NotImplementedException("Functionality not availble on clients.");
    }

    public void writeBlobTo(Transaction trans, BlobImpl blob, File file) throws IOException {
        MsgBlob msg = (MsgBlob)Msg.READ_BLOB.getWriterForInt(trans, (int)this.getID(blob));
        msg._blob = blob;
        this.processBlobMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlobFrom(Transaction trans, BlobImpl blob, File file) throws IOException {
        MsgBlob msg = null;
        Object object = this.lock();
        synchronized (object) {
            this.store(blob);
            int id = (int)this.getID(blob);
            msg = (MsgBlob)Msg.WRITE_BLOB.getWriterForInt(trans, id);
            msg._blob = blob;
            blob.setStatus(-3.0);
        }
        this.processBlobMessage(msg);
    }

    public void deleteBlobFile(Transaction trans, BlobImpl blob) {
        MDeleteBlobFile msg = (MDeleteBlobFile)Msg.DELETE_BLOB_FILE.getWriterForInt(trans, (int)this.getID(blob));
        this.writeMsg(msg, false);
    }

    public long[] getIDsForClass(Transaction trans, ClassMetadata clazz) {
        MsgD msg = Msg.GET_INTERNAL_IDS.getWriterForInt(trans, clazz.getID());
        this.write(msg);
        ByteArrayBuffer reader = this.expectedByteResponse(Msg.ID_LIST);
        int size = reader.readInt();
        long[] ids = new long[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = reader.readInt();
        }
        return ids;
    }

    public QueryResult classOnlyQuery(Transaction trans, ClassMetadata clazz) {
        long[] ids = clazz.getIDs(trans);
        ClientQueryResult resClient = new ClientQueryResult(trans, ids.length);
        for (int i = 0; i < ids.length; ++i) {
            resClient.add((int)ids[i]);
        }
        return resClient;
    }

    public QueryResult executeQuery(QQuery query) {
        Transaction trans = query.getTransaction();
        query.evaluationMode(this.config().queryEvaluationMode());
        query.marshall();
        MsgD msg = Msg.QUERY_EXECUTE.getWriter(Serializer.marshall(trans, (Object)query));
        this.write(msg);
        return this.readQueryResult(trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBatchedMessages() {
        Object object = this.lock();
        synchronized (object) {
            if (this._batchedMessages.isEmpty()) {
                return;
            }
            MsgD multibytes = Msg.WRITE_BATCHED_MESSAGES.getWriterForLength(this.transaction(), this._batchedQueueLength);
            multibytes.writeInt(this._batchedMessages.size());
            Iterator4 iter = this._batchedMessages.iterator();
            while (iter.moveNext()) {
                Msg msg = (Msg)iter.current();
                if (msg == null) {
                    multibytes.writeInt(0);
                    continue;
                }
                multibytes.writeInt(msg.payLoad().length());
                multibytes.payLoad().append(msg.payLoad()._buffer);
            }
            this.writeMessageToSocket(multibytes);
            this.clearBatchedObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToBatch(Msg msg) {
        Object object = this.lock();
        synchronized (object) {
            this._batchedMessages.add(msg);
            this._batchedQueueLength += 4 + msg.payLoad().length();
        }
    }

    private final void clearBatchedObjects() {
        this._batchedMessages.clear();
        this._batchedQueueLength = 4;
    }

    int timeout() {
        return this.configImpl().timeoutClientSocket();
    }

    protected void shutdownDataStorage() {
        this.shutDownCommunicationRessources();
    }

    private void shutDownCommunicationRessources() {
        this.stopHeartBeat();
        this.closeMessageDispatcher();
        this._synchronousMessageQueue.stop();
        this._asynchronousMessageQueue.stop();
    }

    public void setDispatcherName(String name) {
    }

    public void startDispatcher() {
    }

    public ClientMessageDispatcher messageDispatcher() {
        return this._singleThreaded ? this : this._messageDispatcher;
    }

    public void onCommittedListener() {
        if (this._singleThreaded) {
            return;
        }
        this.write(Msg.COMMITTED_CALLBACK_REGISTER);
    }

    public int classMetadataIdForName(String name) {
        MsgD msg = Msg.CLASS_METADATA_ID_FOR_NAME.getWriterForString(this.systemTransaction(), name);
        msg.write(this.i_socket);
        MsgD response = (MsgD)this.expectedResponse(Msg.CLASS_ID);
        return response.readInt();
    }

    public int instanceCount(ClassMetadata clazz, Transaction trans) {
        MsgD msg = Msg.INSTANCE_COUNT.getWriterForInt(trans, clazz.getID());
        this.write(msg);
        MsgD response = (MsgD)this.expectedResponse(Msg.INSTANCE_COUNT);
        return response.readInt();
    }
}

