/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ClassInfoHelper;
import com.db4o.internal.cs.ClientTransactionHandle;
import com.db4o.internal.cs.LazyClientObjectSetStub;
import com.db4o.internal.cs.ObjectServerImpl;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.messages.MSwitchToFile;
import com.db4o.internal.cs.messages.MUseTransaction;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.ServerSideMessage;

public final class ServerMessageDispatcherImpl
extends Thread
implements ServerMessageDispatcher {
    private String _clientName;
    private boolean _loggedin;
    private boolean _closeMessageSent;
    private final ObjectServerImpl _server;
    private Socket4 _socket;
    private ClientTransactionHandle _transactionHandle;
    private Hashtable4 _queryResults;
    final int _threadID;
    private CallbackObjectInfoCollections _committedInfo;
    private boolean _caresAboutCommitted;
    private boolean _isClosed;
    private final Object _lock = new Object();
    private final Object _mainLock;

    ServerMessageDispatcherImpl(ObjectServerImpl server, ClientTransactionHandle transactionHandle, Socket4 socket, int threadID, boolean loggedIn, Object mainLock) throws Exception {
        this._mainLock = mainLock;
        this._transactionHandle = transactionHandle;
        this.setDaemon(true);
        this._loggedin = loggedIn;
        this._server = server;
        this._threadID = threadID;
        this.setDispatcherName("" + threadID);
        this._socket = socket;
        this._socket.setSoTimeout(((Config4Impl)server.configure()).timeoutServerSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return true;
            }
            this._isClosed = true;
        }
        object = this._mainLock;
        synchronized (object) {
            this._transactionHandle.releaseTransaction();
            this.sendCloseMessage();
            this._transactionHandle.close();
            this.closeSocket();
            this.removeFromServer();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return;
            }
            this._isClosed = true;
        }
        object = this._mainLock;
        synchronized (object) {
            this.closeSocket();
            this.removeFromServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageDispatcherAlive() {
        Object object = this._lock;
        synchronized (object) {
            return !this._isClosed;
        }
    }

    private void sendCloseMessage() {
        try {
            if (!this._closeMessageSent) {
                this._closeMessageSent = true;
                this.write(Msg.CLOSE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeFromServer() {
        try {
            this._server.removeThread(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSocket() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (Db4oIOException db4oIOException) {
            // empty catch block
        }
    }

    public Transaction getTransaction() {
        return this._transactionHandle.transaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.messageLoop();
        }
        finally {
            this.close();
        }
    }

    private void messageLoop() {
        while (this.isMessageDispatcherAlive()) {
            try {
                if (this.messageProcessor()) continue;
                return;
            }
            catch (Db4oIOException e) {
                if (DTrace.enabled) {
                    DTrace.ADD_TO_CLASS_INDEX.log(e.toString());
                }
                return;
            }
        }
    }

    private boolean messageProcessor() throws Db4oIOException {
        Msg message = Msg.readMessage(this, this.getTransaction(), this._socket);
        if (message == null) {
            return true;
        }
        if (!this._loggedin && !Msg.LOGIN.equals(message)) {
            return true;
        }
        if (this.isMessageDispatcherAlive()) {
            return ((ServerSideMessage)((Object)message)).processAtServer();
        }
        return false;
    }

    public ObjectServerImpl server() {
        return this._server;
    }

    public void queryResultFinalized(int queryResultID) {
        this._queryResults.remove(queryResultID);
    }

    public void mapQueryResultToID(LazyClientObjectSetStub stub, int queryResultID) {
        if (this._queryResults == null) {
            this._queryResults = new Hashtable4();
        }
        this._queryResults.put(queryResultID, (Object)stub);
    }

    public LazyClientObjectSetStub queryResultForID(int queryResultID) {
        return (LazyClientObjectSetStub)this._queryResults.get(queryResultID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToFile(MSwitchToFile message) {
        Object object = this._mainLock;
        synchronized (object) {
            String fileName = message.readString();
            try {
                this._transactionHandle.releaseTransaction();
                this._transactionHandle.acquireTransactionForFile(fileName);
                this.write(Msg.OK);
            }
            catch (Exception e) {
                this._transactionHandle.releaseTransaction();
                this.write(Msg.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMainFile() {
        Object object = this._mainLock;
        synchronized (object) {
            this._transactionHandle.releaseTransaction();
            this.write(Msg.OK);
        }
    }

    public void useTransaction(MUseTransaction message) {
        int threadID = message.readInt();
        Transaction transToUse = this._server.findTransaction(threadID);
        this._transactionHandle.transaction(transToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Msg msg) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return false;
            }
            return msg.write(this._socket);
        }
    }

    public Socket4 socket() {
        return this._socket;
    }

    public String name() {
        return this._clientName;
    }

    public void setDispatcherName(String name) {
        this._clientName = name;
        this.setName("db4o server message dispatcher " + name);
    }

    public int dispatcherID() {
        return this._threadID;
    }

    public void login() {
        this._loggedin = true;
    }

    public void startDispatcher() {
        this.start();
    }

    public boolean caresAboutCommitted() {
        return this._caresAboutCommitted;
    }

    public void caresAboutCommitted(boolean care) {
        this._caresAboutCommitted = true;
        this.server().checkCaresAboutCommitted();
    }

    public CallbackObjectInfoCollections committedInfo() {
        return this._committedInfo;
    }

    public void dispatchCommitted(CallbackObjectInfoCollections committedInfo) {
        this._committedInfo = committedInfo;
    }

    public boolean willDispatchCommitted() {
        return this.server().caresAboutCommitted();
    }

    public ClassInfoHelper classInfoHelper() {
        return this.server().classInfoHelper();
    }
}

