/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.DTrace;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.IntIterator4Adaptor;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.TreeKeyIterator;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.IDGenerator;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectID;
import com.db4o.internal.ReadsObjectIds;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.fieldindex.FieldIndexProcessor;
import com.db4o.internal.fieldindex.FieldIndexProcessorResult;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.query.processor.Order;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.query.processor.QOrder;
import com.db4o.typehandlers.TypeHandler4;

public final class QCandidates
implements Visitor4 {
    public final LocalTransaction i_trans;
    public Tree i_root;
    private List4 i_constraints;
    ClassMetadata i_yapClass;
    private QField i_field;
    QCon i_currentConstraint;
    Tree i_ordered;
    private int _majorOrderingID;
    private IDGenerator _idGenerator;
    private boolean _loadedFromClassIndex;

    QCandidates(LocalTransaction a_trans, ClassMetadata a_yapClass, QField a_field) {
        this.i_trans = a_trans;
        this.i_yapClass = a_yapClass;
        this.i_field = a_field;
        if (a_field == null || a_field.i_yapField == null || !(a_field.i_yapField.getHandler() instanceof ClassMetadata)) {
            return;
        }
        ClassMetadata yc = (ClassMetadata)a_field.i_yapField.getHandler();
        if (this.i_yapClass == null) {
            this.i_yapClass = yc;
        } else if ((yc = this.i_yapClass.getHigherOrCommonHierarchy(yc)) != null) {
            this.i_yapClass = yc;
        }
    }

    public QCandidate add(QCandidate candidate) {
        this.i_root = Tree.add(this.i_root, candidate);
        if (candidate._size == 0) {
            return candidate.getRoot();
        }
        return candidate;
    }

    void addConstraint(QCon a_constraint) {
        this.i_constraints = new List4(this.i_constraints, a_constraint);
    }

    void addOrder(QOrder a_order) {
        this.i_ordered = Tree.add(this.i_ordered, a_order);
    }

    void applyOrdering(Tree orderedCandidates, int orderingID) {
        if (orderedCandidates == null || this.i_root == null) {
            return;
        }
        int absoluteOrderingID = Math.abs(orderingID);
        boolean major = this.treatOrderingIDAsMajor(absoluteOrderingID);
        if (major && !this.isUnordered()) {
            this.swapMajorOrderToMinor();
        }
        this.hintNewOrder(orderedCandidates, major);
        this.i_root = this.recreateTreeFromCandidates();
        if (major) {
            this._majorOrderingID = absoluteOrderingID;
        }
    }

    public QCandidate readSubCandidate(QueryingReadContext context, TypeHandler4 handler) {
        ObjectID objectID = ObjectID.NOT_POSSIBLE;
        try {
            int offset = context.offset();
            if (handler instanceof ReadsObjectIds) {
                objectID = ((ReadsObjectIds)((Object)handler)).readObjectID(context);
            }
            if (objectID.isValid()) {
                return new QCandidate(this, null, objectID._id);
            }
            if (objectID == ObjectID.NOT_POSSIBLE) {
                context.seek(offset);
                Object obj = context.read(handler);
                if (obj != null) {
                    return new QCandidate(this, obj, 0);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private Tree recreateTreeFromCandidates() {
        Collection4 col = this.collectCandidates();
        Tree newTree = null;
        Iterator4 i = col.iterator();
        while (i.moveNext()) {
            QCandidate candidate = (QCandidate)i.current();
            candidate._preceding = null;
            candidate._subsequent = null;
            candidate._size = 1;
            newTree = Tree.add(newTree, candidate);
        }
        return newTree;
    }

    private Collection4 collectCandidates() {
        final Collection4 col = new Collection4();
        this.i_root.traverse(new Visitor4(){

            public void visit(Object a_object) {
                QCandidate candidate = (QCandidate)a_object;
                col.add(candidate);
            }
        });
        return col;
    }

    private void hintNewOrder(Tree orderedCandidates, final boolean major) {
        final int[] currentOrder = new int[]{0};
        final QOrder[] lastOrder = new QOrder[]{null};
        orderedCandidates.traverse(new Visitor4(){

            public void visit(Object a_object) {
                QOrder qo = (QOrder)a_object;
                if (!qo.isEqual(lastOrder[0])) {
                    currentOrder[0] = currentOrder[0] + 1;
                }
                QCandidate candidate = qo._candidate.getRoot();
                candidate.hintOrder(currentOrder[0], major);
                lastOrder[0] = qo;
            }
        });
    }

    private void swapMajorOrderToMinor() {
        this.i_root.traverse(new Visitor4(){

            public void visit(Object obj) {
                QCandidate candidate = (QCandidate)obj;
                Order order = (Order)candidate._order;
                order.swapMajorToMinor();
            }
        });
    }

    private boolean treatOrderingIDAsMajor(int absoluteOrderingID) {
        return this.isUnordered() || this.isMoreRelevantOrderingID(absoluteOrderingID);
    }

    private boolean isUnordered() {
        return this._majorOrderingID == 0;
    }

    private boolean isMoreRelevantOrderingID(int absoluteOrderingID) {
        return absoluteOrderingID < this._majorOrderingID;
    }

    void collect(QCandidates a_candidates) {
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon qCon = (QCon)i.current();
            this.setCurrentConstraint(qCon);
            qCon.collect(a_candidates);
        }
        this.setCurrentConstraint(null);
    }

    void execute() {
        FieldIndexProcessorResult result;
        if (DTrace.enabled) {
            DTrace.QUERY_PROCESS.log();
        }
        if ((result = this.processFieldIndexes()).foundIndex()) {
            this.i_root = result.toQCandidate(this);
        } else {
            this.loadFromClassIndex();
        }
        this.evaluate();
    }

    public Iterator4 executeSnapshot(Collection4 executionPath) {
        IntIterator4Adaptor indexIterator = new IntIterator4Adaptor(this.iterateIndex(this.processFieldIndexes()));
        Tree idRoot = TreeInt.addAll(null, indexIterator);
        TreeKeyIterator snapshotIterator = new TreeKeyIterator(idRoot);
        Iterator4 singleObjectQueryIterator = this.singleObjectSodaProcessor(snapshotIterator);
        return this.mapIdsToExecutionPath(singleObjectQueryIterator, executionPath);
    }

    private Iterator4 singleObjectSodaProcessor(Iterator4 indexIterator) {
        return Iterators.map(indexIterator, new Function4(){

            public Object apply(Object current) {
                int id = (Integer)current;
                QCandidate candidate = new QCandidate(QCandidates.this, null, id);
                QCandidates.this.i_root = candidate;
                QCandidates.this.evaluate();
                if (!candidate.include()) {
                    return Iterators.SKIP;
                }
                return current;
            }
        });
    }

    public Iterator4 executeLazy(Collection4 executionPath) {
        Iterator4 indexIterator = this.iterateIndex(this.processFieldIndexes());
        Iterator4 singleObjectQueryIterator = this.singleObjectSodaProcessor(indexIterator);
        return this.mapIdsToExecutionPath(singleObjectQueryIterator, executionPath);
    }

    private Iterator4 iterateIndex(FieldIndexProcessorResult result) {
        if (result.noMatch()) {
            return Iterators.EMPTY_ITERATOR;
        }
        if (result.foundIndex()) {
            return result.iterateIDs();
        }
        if (this.i_yapClass.isPrimitive()) {
            return Iterators.EMPTY_ITERATOR;
        }
        return BTreeClassIndexStrategy.iterate(this.i_yapClass, this.i_trans);
    }

    private Iterator4 mapIdsToExecutionPath(Iterator4 singleObjectQueryIterator, Collection4 executionPath) {
        if (executionPath == null) {
            return singleObjectQueryIterator;
        }
        Iterator4 res = singleObjectQueryIterator;
        Iterator4 executionPathIterator = executionPath.iterator();
        while (executionPathIterator.moveNext()) {
            final String fieldName = (String)executionPathIterator.current();
            res = Iterators.concat(Iterators.map(res, new Function4(){

                public Object apply(Object current) {
                    int id = (Integer)current;
                    CollectIdContext context = CollectIdContext.forID(QCandidates.this.i_trans, id);
                    if (context == null) {
                        return Iterators.SKIP;
                    }
                    context.classMetadata().collectIDs(context, fieldName);
                    return new TreeKeyIterator(context.ids());
                }
            }));
        }
        return res;
    }

    public ObjectContainerBase stream() {
        return this.i_trans.container();
    }

    public int classIndexEntryCount() {
        return this.i_yapClass.indexEntryCount(this.i_trans);
    }

    private FieldIndexProcessorResult processFieldIndexes() {
        if (this.i_constraints == null) {
            return FieldIndexProcessorResult.NO_INDEX_FOUND;
        }
        return new FieldIndexProcessor(this).run();
    }

    void evaluate() {
        if (this.i_constraints == null) {
            return;
        }
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon qCon = (QCon)i.current();
            qCon.setCandidates(this);
            qCon.evaluateSelf();
        }
        i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).evaluateSimpleChildren();
        }
        i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).evaluateEvaluations();
        }
        i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).evaluateCreateChildrenCandidates();
        }
        i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).evaluateCollectChildren();
        }
        i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).evaluateChildren();
        }
    }

    boolean isEmpty() {
        final boolean[] ret = new boolean[]{true};
        this.traverse(new Visitor4(){

            public void visit(Object obj) {
                if (((QCandidate)obj)._include) {
                    ret[0] = false;
                }
            }
        });
        return ret[0];
    }

    boolean filter(Visitor4 a_host) {
        if (this.i_root != null) {
            this.i_root.traverse(a_host);
            this.i_root = this.i_root.filter(new Predicate4(){

                public boolean match(Object a_candidate) {
                    return ((QCandidate)a_candidate)._include;
                }
            });
        }
        return this.i_root != null;
    }

    int generateCandidateId() {
        if (this._idGenerator == null) {
            this._idGenerator = new IDGenerator();
        }
        return -this._idGenerator.next();
    }

    public Iterator4 iterateConstraints() {
        if (this.i_constraints == null) {
            return Iterators.EMPTY_ITERATOR;
        }
        return new Iterator4Impl(this.i_constraints);
    }

    void loadFromClassIndex() {
        if (!this.isEmpty()) {
            return;
        }
        final TreeIntBuilder result = new TreeIntBuilder();
        ClassIndexStrategy index = this.i_yapClass.index();
        index.traverseAll(this.i_trans, new Visitor4(){

            public void visit(Object obj) {
                result.add(new QCandidate(QCandidates.this, null, (Integer)obj));
            }
        });
        this.i_root = result.tree;
        DiagnosticProcessor dp = this.i_trans.container()._handlers._diagnosticProcessor;
        if (dp.enabled()) {
            dp.loadedFromClassIndex(this.i_yapClass);
        }
        this._loadedFromClassIndex = true;
    }

    void setCurrentConstraint(QCon a_constraint) {
        this.i_currentConstraint = a_constraint;
    }

    void traverse(Visitor4 a_visitor) {
        if (this.i_root != null) {
            this.i_root.traverse(a_visitor);
        }
    }

    boolean tryAddConstraint(QCon a_constraint) {
        QField qf;
        if (this.i_field != null && (qf = a_constraint.getField()) != null && this.i_field.i_name != null && !this.i_field.i_name.equals(qf.i_name)) {
            return false;
        }
        if (this.i_yapClass == null || a_constraint.isNullConstraint()) {
            this.addConstraint(a_constraint);
            return true;
        }
        ClassMetadata yc = a_constraint.getYapClass();
        if (yc != null && (yc = this.i_yapClass.getHigherOrCommonHierarchy(yc)) != null) {
            this.i_yapClass = yc;
            this.addConstraint(a_constraint);
            return true;
        }
        this.addConstraint(a_constraint);
        return false;
    }

    public void visit(Object a_tree) {
        QCandidate parent = (QCandidate)a_tree;
        if (parent.createChild(this)) {
            return;
        }
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).visitOnNull(parent.getRoot());
        }
    }

    public String toString() {
        final StringBuffer sb = new StringBuffer();
        this.i_root.traverse(new Visitor4(){

            public void visit(Object obj) {
                QCandidate candidate = (QCandidate)obj;
                sb.append(" ");
                sb.append(candidate._key);
            }
        });
        return sb.toString();
    }

    public void clearOrdering() {
        this.i_ordered = null;
    }

    public final Transaction transaction() {
        return this.i_trans;
    }

    public boolean wasLoadedFromClassIndex() {
        return this._loadedFromClassIndex;
    }

    public boolean fitsIntoExistingConstraintHierarchy(QCon constraint) {
        QField qf;
        if (this.i_field != null && (qf = constraint.getField()) != null && this.i_field.i_name != null && !this.i_field.i_name.equals(qf.i_name)) {
            return false;
        }
        if (this.i_yapClass == null || constraint.isNullConstraint()) {
            return true;
        }
        ClassMetadata classMetadata = constraint.getYapClass();
        if (classMetadata == null) {
            return false;
        }
        if ((classMetadata = this.i_yapClass.getHigherOrCommonHierarchy(classMetadata)) == null) {
            return false;
        }
        this.i_yapClass = classMetadata;
        return true;
    }

    static final class TreeIntBuilder {
        public TreeInt tree;

        TreeIntBuilder() {
        }

        public void add(TreeInt node) {
            this.tree = (TreeInt)Tree.add(this.tree, node);
        }
    }
}

