/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.core;

import com.db4o.foundation.Tree;
import com.db4o.foundation.TreeNodeIterator;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.TreeIntObject;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectorConfiguration;
import com.db4o.reflect.core.ConstructorAwareReflectClass;
import com.db4o.reflect.core.PlatformReflectConstructor;
import com.db4o.reflect.core.ReflectConstructor;
import com.db4o.reflect.core.ReflectConstructorSpec;

public class ConstructorSupport {
    public static ReflectConstructorSpec createConstructor(ConstructorAwareReflectClass claxx, Class clazz, ReflectorConfiguration config, ReflectConstructor[] constructors) {
        if (claxx == null) {
            return ReflectConstructorSpec.INVALID_CONSTRUCTOR;
        }
        if (claxx.isAbstract() || claxx.isInterface()) {
            return ReflectConstructorSpec.INVALID_CONSTRUCTOR;
        }
        if (!Platform4.callConstructor()) {
            ReflectConstructor serializableConstructor;
            boolean skipConstructor;
            boolean bl = skipConstructor = !config.callConstructor(claxx);
            if (!claxx.isCollection() && (serializableConstructor = ConstructorSupport.skipConstructor(claxx, skipConstructor, config.testConstructors())) != null) {
                return new ReflectConstructorSpec(serializableConstructor, null);
            }
        }
        if (!config.testConstructors()) {
            return new ReflectConstructorSpec(new PlatformReflectConstructor(clazz), null);
        }
        if (ReflectPlatform.createInstance(clazz) != null) {
            return new ReflectConstructorSpec(new PlatformReflectConstructor(clazz), null);
        }
        Tree sortedConstructors = ConstructorSupport.sortConstructorsByParamsCount(constructors);
        return ConstructorSupport.findConstructor(claxx, sortedConstructors);
    }

    private static ReflectConstructorSpec findConstructor(ReflectClass claxx, Tree sortedConstructors) {
        if (sortedConstructors == null) {
            return ReflectConstructorSpec.INVALID_CONSTRUCTOR;
        }
        TreeNodeIterator iter = new TreeNodeIterator(sortedConstructors);
        while (iter.moveNext()) {
            Object obj = iter.current();
            ReflectConstructor constructor = (ReflectConstructor)((TreeIntObject)obj)._object;
            ReflectClass[] paramTypes = constructor.getParameterTypes();
            Object[] params = new Object[paramTypes.length];
            for (int j = 0; j < params.length; ++j) {
                params[j] = paramTypes[j].nullValue();
            }
            Object res = constructor.newInstance(params);
            if (res == null) continue;
            return new ReflectConstructorSpec(constructor, params);
        }
        return ReflectConstructorSpec.INVALID_CONSTRUCTOR;
    }

    private static Tree sortConstructorsByParamsCount(ReflectConstructor[] constructors) {
        Tree sortedConstructors = null;
        for (int i = 0; i < constructors.length; ++i) {
            int parameterCount = constructors[i].getParameterTypes().length;
            sortedConstructors = Tree.add(sortedConstructors, new TreeIntObject(i + constructors.length * parameterCount, constructors[i]));
        }
        return sortedConstructors;
    }

    public static ReflectConstructor skipConstructor(ConstructorAwareReflectClass claxx, boolean skipConstructor, boolean testConstructor) {
        if (!skipConstructor) {
            return null;
        }
        ReflectConstructor serializableConstructor = claxx.getSerializableConstructor();
        if (serializableConstructor == null) {
            return null;
        }
        if (!testConstructor) {
            return serializableConstructor;
        }
        Object obj = serializableConstructor.newInstance(null);
        if (obj != null) {
            return serializableConstructor;
        }
        return null;
    }
}

