/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import java.util.ArrayList;
import org.restlet.data.Parameter;
import org.restlet.data.RecipientInfo;
import org.restlet.engine.http.header.RecipientInfoReader;
import org.restlet.engine.http.header.RecipientInfoWriter;
import org.restlet.test.RestletTestCase;

public class RecipientInfoTestCase
extends RestletTestCase {
    public void testVia() {
        Parameter via1a = new Parameter("Via", "1.0 fred, 1.1 nowhere.com (Apache/1.1)");
        Parameter via1b = new Parameter("Via", "HTTP/1.0 fred, HTTP/1.1 nowhere.com (Apache/1.1)");
        Parameter via1c = new Parameter("Via", "HTTP/1.0 fred (Apache/1.1), HTTP/1.1 nowhere.com");
        ArrayList recipients = new ArrayList();
        RecipientInfoReader.addValues((Parameter)via1a, recipients);
        RecipientInfoTestCase.assertEquals((int)2, (int)recipients.size());
        RecipientInfo recipient1 = (RecipientInfo)recipients.get(0);
        RecipientInfo recipient2 = (RecipientInfo)recipients.get(1);
        RecipientInfoTestCase.assertEquals((String)"1.0", (String)recipient1.getProtocol().getVersion());
        RecipientInfoTestCase.assertEquals((String)"1.1", (String)recipient2.getProtocol().getVersion());
        RecipientInfoTestCase.assertEquals((String)"fred", (String)recipient1.getName());
        RecipientInfoTestCase.assertEquals((String)"nowhere.com", (String)recipient2.getName());
        RecipientInfoTestCase.assertNull((Object)recipient1.getComment());
        RecipientInfoTestCase.assertEquals((String)"Apache/1.1", (String)recipient2.getComment());
        String header = RecipientInfoWriter.write(recipients);
        RecipientInfoTestCase.assertEquals((String)via1b.getValue(), (String)header);
        recipients = new ArrayList();
        RecipientInfoReader.addValues((Parameter)via1c, recipients);
        recipient1 = (RecipientInfo)recipients.get(0);
        recipient2 = (RecipientInfo)recipients.get(1);
        RecipientInfoTestCase.assertEquals((String)"1.0", (String)recipient1.getProtocol().getVersion());
        RecipientInfoTestCase.assertEquals((String)"1.1", (String)recipient2.getProtocol().getVersion());
        RecipientInfoTestCase.assertEquals((String)"fred", (String)recipient1.getName());
        RecipientInfoTestCase.assertEquals((String)"nowhere.com", (String)recipient2.getName());
        RecipientInfoTestCase.assertEquals((String)"Apache/1.1", (String)recipient1.getComment());
        RecipientInfoTestCase.assertNull((Object)recipient2.getComment());
    }
}

