/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.xml.TransformRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.restlet.test.engine.BaseConnectorsTestCase;

public class GetChunkedTestCase
extends BaseConnectorsTestCase {
    protected void call(String uri) throws Exception {
        Request request = new Request(Method.GET, uri);
        Client c = new Client(Protocol.HTTP);
        Response r = c.handle(request);
        GetChunkedTestCase.assertEquals((String)r.getStatus().getDescription(), (Object)Status.SUCCESS_OK, (Object)r.getStatus());
        GetChunkedTestCase.assertEquals((String)"Hello world", (String)r.getEntity().getText());
    }

    protected Application createApplication(Component component) {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attach("/test", GetChunkedTestResource.class);
                return router;
            }
        };
        return application;
    }

    public static class GetChunkedTestResource
    extends ServerResource {
        public GetChunkedTestResource() {
            this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        }

        public Representation get(Variant variant) {
            StringRepresentation source = new StringRepresentation((CharSequence)"<?xml version='1.0'?><mail>Hello world</mail>", MediaType.APPLICATION_XML);
            StringBuilder builder = new StringBuilder();
            builder.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">");
            builder.append("<xsl:output method=\"text\"/>");
            builder.append("<xsl:template match=\"/\">");
            builder.append("<xsl:apply-templates />");
            builder.append("</xsl:template>");
            builder.append("</xsl:stylesheet>");
            StringRepresentation transformSheet = new StringRepresentation((CharSequence)builder.toString(), MediaType.TEXT_XML);
            TransformRepresentation representation = new TransformRepresentation(this.getContext(), (Representation)source, (Representation)transformSheet);
            representation.setMediaType(variant.getMediaType());
            return representation;
        }
    }
}

