/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxb;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.ext.jaxb.JaxbRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.restlet.test.RestletTestCase;
import org.restlet.test.ext.jaxb.Sample;

public class JaxbIntegrationConverterTestCase
extends RestletTestCase {
    private static final String IN_STRING = "foo";
    private static final String HELLO_OUT_STRING = "Hello World foo";
    private Component component;
    private String uri;

    public void setUp() throws Exception {
        super.setUp();
        this.component = new Component();
        Server server = this.component.getServers().add(Protocol.HTTP, 0);
        Application application = this.createApplication(this.component);
        this.component.getDefaultHost().attach((Restlet)application);
        this.component.start();
        this.uri = "http://localhost:" + server.getEphemeralPort() + "/test";
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.component != null) {
            this.component.stop();
        }
        this.component = null;
    }

    protected Application createApplication(Component component) {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attach("/test", SampleResource.class);
                return router;
            }
        };
        return application;
    }

    public void testIntegration() throws Exception {
        Client client = new Client(new Context(), Arrays.asList(Protocol.HTTP));
        Request request = new Request(Method.POST, this.uri);
        request.setEntity((Representation)new JaxbRepresentation((Object)new Sample(IN_STRING)));
        Response response = client.handle(request);
        JaxbRepresentation resultRepresentation = new JaxbRepresentation(response.getEntity(), Sample.class);
        Sample sample = (Sample)resultRepresentation.getObject();
        JaxbIntegrationConverterTestCase.assertEquals((String)HELLO_OUT_STRING, (String)sample.getVal());
        request = new Request(Method.PUT, this.uri);
        request.setEntity((Representation)new JaxbRepresentation((Object)new Sample(IN_STRING)));
        response = client.handle(request);
        resultRepresentation = new JaxbRepresentation(response.getEntity(), Sample.class);
        sample = (Sample)resultRepresentation.getObject();
        JaxbIntegrationConverterTestCase.assertEquals((String)HELLO_OUT_STRING, (String)sample.getVal());
        request = new Request(Method.GET, this.uri);
        response = client.handle(request);
        resultRepresentation = new JaxbRepresentation(response.getEntity(), Sample.class);
        sample = (Sample)resultRepresentation.getObject();
        JaxbIntegrationConverterTestCase.assertEquals((String)IN_STRING, (String)sample.getVal());
    }

    public void testWithClientResource() throws Exception {
        ClientResource sampleResource = new ClientResource(this.uri);
        ArrayList<Preference> m = new ArrayList<Preference>();
        m.add(new Preference((Metadata)MediaType.APPLICATION_XML));
        sampleResource.getClientInfo().setAcceptedMediaTypes(m);
        Sample sample = new Sample(IN_STRING);
        sample = (Sample)sampleResource.post((Object)sample, Sample.class);
        JaxbIntegrationConverterTestCase.assertEquals((String)HELLO_OUT_STRING, (String)sample.getVal());
        sampleResource.put((Object)sample);
        JaxbIntegrationConverterTestCase.assertTrue((boolean)sampleResource.getStatus().isSuccess());
        sample = (Sample)sampleResource.put((Object)sample, Sample.class);
        JaxbIntegrationConverterTestCase.assertEquals((String)HELLO_OUT_STRING, (String)sample.getVal());
        sample = (Sample)sampleResource.get(Sample.class);
        JaxbIntegrationConverterTestCase.assertEquals((String)IN_STRING, (String)sample.getVal());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SampleResource
    extends ServerResource {
        @Post(value="xml")
        public Sample post(Sample sample) {
            Assert.assertNotNull((Object)sample);
            return new Sample(JaxbIntegrationConverterTestCase.HELLO_OUT_STRING);
        }

        @Get(value="xml")
        public Sample getSample() {
            return new Sample(JaxbIntegrationConverterTestCase.IN_STRING);
        }

        @Put(value="xml:xml")
        public JaxbRepresentation<Sample> putSample(Sample sample) {
            Assert.assertNotNull((Object)sample);
            return new JaxbRepresentation((Object)new Sample(JaxbIntegrationConverterTestCase.HELLO_OUT_STRING));
        }
    }
}

