/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.representation;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.junit.Test;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.representation.DigesterRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class DigestTestCase
extends RestletTestCase {
    private Component component;

    protected void setUp() throws Exception {
        this.component = new Component();
        this.component.getServers().add(Protocol.HTTP, TEST_PORT);
        this.component.getDefaultHost().attach((Restlet)new TestDigestApplication());
        this.component.start();
    }

    protected void tearDown() throws Exception {
        this.component.stop();
        this.component = null;
    }

    @Test
    public void testGet() throws IOException, NoSuchAlgorithmException {
        Client client = new Client(Protocol.HTTP);
        Request request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/");
        StringRepresentation rep = new StringRepresentation((CharSequence)"0123456789");
        try {
            DigesterRepresentation digester = new DigesterRepresentation((Representation)rep);
            digester.exhaust();
            digester.setDigest(digester.computeDigest());
            request.setEntity((Representation)digester);
            Response response = client.handle(request);
            DigestTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
            digester = new DigesterRepresentation(response.getEntity());
            digester.exhaust();
            DigestTestCase.assertTrue((boolean)digester.checkDigest());
        }
        catch (Exception e) {
            DigestTestCase.fail((String)e.getMessage());
        }
    }

    private static class TestDigestApplication
    extends Application {
        private TestDigestApplication() {
        }

        public Restlet createInboundRoot() {
            Restlet restlet = new Restlet(){

                public void handle(Request request, Response response) {
                    Representation rep = request.getEntity();
                    try {
                        DigesterRepresentation digester = new DigesterRepresentation(rep);
                        digester.exhaust();
                        if (digester.checkDigest()) {
                            response.setStatus(Status.SUCCESS_OK);
                            StringRepresentation f = new StringRepresentation((CharSequence)"9876543210");
                            digester = new DigesterRepresentation((Representation)f);
                            digester.exhaust();
                            digester.setDigest(digester.computeDigest());
                            response.setEntity((Representation)digester);
                        } else {
                            response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
            };
            return restlet;
        }
    }
}

