/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Language;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.io.BioUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Directory;
import org.restlet.test.RestletTestCase;

public class DirectoryTestCase
extends RestletTestCase {
    String webSiteURL = "http://myapplication/";
    String baseFileUrl = this.webSiteURL.concat("fichier.txt");
    String baseFileUrlEn = this.webSiteURL.concat("fichier.txt.en");
    String baseFileUrlFr = this.webSiteURL.concat("fichier.txt.fr");
    String baseFileUrlFrBis = this.webSiteURL.concat("fichier.fr.txt");
    String percentEncodedFileUrl = this.webSiteURL.concat(Reference.encode((String)"a new %file.txt.fr"));
    String percentEncodedFileUrlBis = this.webSiteURL.concat("a+new%20%25file.txt.fr");
    String testCreationDirectory = this.webSiteURL.concat("dir/does/not/exist");
    String testCreationFile = this.webSiteURL.concat("file/does/not/exist");
    String testCreationTextFile = this.webSiteURL.concat("text/file/does/not/exist.txt");
    File testDir;

    public static void main(String[] args) throws Exception {
        new DirectoryTestCase().testDirectory();
    }

    private Response handle(Application application, String baseRef, String resourceRef, Method method, Representation entity, String testCode) {
        Request request = new Request();
        Response response = new Response(request);
        request.setResourceRef(resourceRef);
        request.setOriginalRef(request.getResourceRef().getTargetRef());
        request.getResourceRef().setBaseRef(baseRef);
        request.setMethod(method);
        if (Method.PUT.equals((Object)method)) {
            request.setEntity(entity);
        }
        application.handle(request, response);
        System.out.println("[test, status]=[" + testCode + ", " + response.getStatus() + "]");
        return response;
    }

    public void testDirectory() throws Exception {
        this.testDir = new File(System.getProperty("java.io.tmpdir"), "DirectoryTestCase/tests1" + new Date().getTime());
        Component clientComponent = new Component();
        clientComponent.getClients().add(Protocol.FILE);
        MyApplication application = new MyApplication(this.testDir);
        clientComponent.getDefaultHost().attach("", (Restlet)application);
        clientComponent.start();
        application.getTunnelService().setExtensionsTunnel(true);
        BioUtils.delete((File)this.testDir, (boolean)true);
        this.testDir = new File(System.getProperty("java.io.tmpdir"), "DirectoryTestCase/tests2" + new Date().getTime());
        this.testDir.mkdirs();
        application.setTestDirectory(this.testDir);
        this.testDirectory(application, application.getDirectory(), "index");
        BioUtils.delete((File)this.testDir, (boolean)true);
        this.testDir = new File(System.getProperty("java.io.tmpdir"), "DirectoryTestCase/tests3" + new Date().getTime());
        this.testDir.mkdirs();
        application.setTestDirectory(this.testDir);
        this.testDirectory(application, application.getDirectory(), "");
        application.getTunnelService().setExtensionsTunnel(false);
        BioUtils.delete((File)this.testDir, (boolean)true);
        this.testDir = new File(System.getProperty("java.io.tmpdir"), "DirectoryTestCase/tests4" + new Date().getTime());
        this.testDir.mkdirs();
        application.setTestDirectory(this.testDir);
        this.testDirectory(application, application.getDirectory(), "index");
        BioUtils.delete((File)this.testDir, (boolean)true);
        this.testDir = new File(System.getProperty("java.io.tmpdir"), "DirectoryTestCase/tests5" + new Date().getTime());
        this.testDir.mkdirs();
        application.setTestDirectory(this.testDir);
        this.testDirectory(application, application.getDirectory(), "");
        BioUtils.delete((File)this.testDir, (boolean)true);
        this.testDir = new File(System.getProperty("java.io.tmpdir"), "DirectoryTestCase/tests6" + new Date().getTime());
        this.testDir.mkdirs();
        application.setTestDirectory(this.testDir);
        this.testDirectoryDeeplyAccessible(application, application.getDirectory());
        clientComponent.stop();
    }

    private void testDirectoryDeeplyAccessible(MyApplication application, Directory directory) throws IOException {
        File testDirectory = new File(this.testDir, "dir/subDir");
        testDirectory.mkdirs();
        File testFile = File.createTempFile("test", ".txt", testDirectory);
        directory.setDeeplyAccessible(true);
        Response response = this.handle(application, this.webSiteURL, this.webSiteURL.concat("dir/subDir/"), Method.GET, null, "deep access 1");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.webSiteURL.concat("dir/subDir/").concat(testFile.getName()), Method.GET, null, "deep access 2");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        directory.setDeeplyAccessible(false);
        response = this.handle(application, this.webSiteURL, this.webSiteURL.concat("dir/subDir/"), Method.GET, null, "deep access 3");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.webSiteURL.concat("dir/subDir/").concat(testFile.getName()), Method.GET, null, "deep access 4");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
    }

    private void testDirectory(MyApplication application, Directory directory, String indexName) throws IOException {
        File testFile = File.createTempFile("test", ".txt", this.testDir);
        File testDirectory = new File(this.testDir, "try");
        testDirectory.mkdir();
        String testFileUrl = this.webSiteURL.concat(testFile.getName());
        String testDirectoryUrl = this.webSiteURL.concat(testDirectory.getName());
        directory.setIndexName(indexName);
        directory.setListingAllowed(false);
        Response response = this.handle(application, this.webSiteURL, this.webSiteURL, Method.GET, null, "1a");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        directory.setListingAllowed(true);
        response = this.handle(application, this.webSiteURL, this.webSiteURL, Method.GET, null, "1b");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        if (response.getStatus().equals((Object)Status.SUCCESS_OK)) {
            response.getEntity().write((OutputStream)System.out);
        }
        response = this.handle(application, this.webSiteURL, testFileUrl, Method.GET, null, "2a");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, testFileUrl, Method.HEAD, null, "2a");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.webSiteURL + "123456.txt", Method.GET, null, "2b");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        directory.setModifiable(false);
        response = this.handle(application, this.webSiteURL, this.baseFileUrl, Method.PUT, (Representation)new StringRepresentation((CharSequence)"this is test 3a"), "3a");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_METHOD_NOT_ALLOWED, (Object)response.getStatus());
        directory.setModifiable(true);
        StringRepresentation rep = new StringRepresentation((CharSequence)"this is test 3b");
        rep.getLanguages().add(Language.FRENCH);
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.PUT, (Representation)rep, "3b");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_CREATED, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrl, Method.GET, null, "4");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        if (response.getStatus().equals((Object)Status.SUCCESS_OK)) {
            response.getEntity().write((OutputStream)System.out);
            System.out.println("");
        }
        response = this.handle(application, this.webSiteURL, this.baseFileUrlEn, Method.PUT, (Representation)new StringRepresentation((CharSequence)"this is a test - En"), "5a");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_CREATED, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrl, Method.HEAD, null, "5b");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlEn, Method.HEAD, null, "5c");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, testFileUrl, Method.DELETE, null, "6a-1");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, testFileUrl, Method.HEAD, null, "6a-2");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, testFileUrl, Method.DELETE, null, "6b");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        if (indexName.length() == 0) {
            response = this.handle(application, this.webSiteURL, testDirectoryUrl, Method.DELETE, null, "6c-1");
            DirectoryTestCase.assertEquals((Object)Status.REDIRECTION_SEE_OTHER, (Object)response.getStatus());
            response = this.handle(application, response.getLocationRef().getIdentifier(), response.getLocationRef().getIdentifier(), Method.DELETE, null, "6c-2");
            DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)response.getStatus());
            response = this.handle(application, this.webSiteURL, this.webSiteURL, Method.DELETE, null, "6c-3");
            DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_FORBIDDEN, (Object)response.getStatus());
        } else {
            response = this.handle(application, this.webSiteURL, testDirectoryUrl + "/", Method.DELETE, null, "6c-2");
            DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
            response = this.handle(application, this.webSiteURL, this.webSiteURL, Method.DELETE, null, "6c-3");
            DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        }
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.PUT, (Representation)new StringRepresentation((CharSequence)"message de test"), "7a");
        DirectoryTestCase.assertTrue((boolean)response.getStatus().isSuccess());
        directory.setNegotiatingContent(false);
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFrBis, Method.PUT, (Representation)new StringRepresentation((CharSequence)"message de test"), "7b-1");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.HEAD, null, "7b-2");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFrBis, Method.HEAD, null, "7b-3");
        DirectoryTestCase.assertTrue((boolean)response.getStatus().equals((Object)Status.SUCCESS_OK));
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.DELETE, null, "7c-1");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.HEAD, null, "7c-2");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFrBis, Method.HEAD, null, "7c-3");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFrBis, Method.DELETE, null, "7c-4");
        DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        directory.setNegotiatingContent(true);
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.PUT, (Representation)new StringRepresentation((CharSequence)"message de test"), "7d-1");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_CREATED, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFrBis, Method.PUT, (Representation)new StringRepresentation((CharSequence)"message de test Bis"), "7d-2");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.HEAD, null, "7d-3");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFrBis, Method.HEAD, null, "7d-4");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        directory.setNegotiatingContent(false);
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.HEAD, null, "7d-5");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        directory.setNegotiatingContent(true);
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.DELETE, null, "7e-1");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.HEAD, null, "7e-2");
        if (application.getTunnelService().isExtensionsTunnel()) {
            DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        } else {
            DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        }
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFrBis, Method.HEAD, null, "7e-8");
        if (application.getTunnelService().isExtensionsTunnel()) {
            DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        } else {
            DirectoryTestCase.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
        }
        response = this.handle(application, this.webSiteURL, this.baseFileUrlFr, Method.DELETE, null, "8a");
        response = this.handle(application, this.webSiteURL, this.baseFileUrlEn, Method.DELETE, null, "8b");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        directory.setModifiable(true);
        rep = new StringRepresentation((CharSequence)"this is test 9a");
        rep.getLanguages().add(Language.FRENCH);
        response = this.handle(application, this.webSiteURL, this.percentEncodedFileUrl, Method.PUT, (Representation)rep, "9a");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_CREATED, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.percentEncodedFileUrl, Method.GET, null, "9b");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        if (response.getStatus().equals((Object)Status.SUCCESS_OK)) {
            response.getEntity().write((OutputStream)System.out);
            System.out.println("");
        }
        response = this.handle(application, this.webSiteURL, this.percentEncodedFileUrlBis, Method.GET, null, "9c");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        if (response.getStatus().equals((Object)Status.SUCCESS_OK)) {
            response.getEntity().write((OutputStream)System.out);
            System.out.println("");
        }
        response = this.handle(application, this.webSiteURL, this.percentEncodedFileUrl, Method.DELETE, null, "9d");
        DirectoryTestCase.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        response = this.handle(application, this.webSiteURL, this.testCreationDirectory, Method.PUT, (Representation)new StringRepresentation((CharSequence)"useless entity"), "10a");
        DirectoryTestCase.assertTrue((boolean)response.getStatus().equals((Object)Status.REDIRECTION_SEE_OTHER));
        response = this.handle(application, this.webSiteURL, this.testCreationDirectory + "/", Method.PUT, (Representation)new StringRepresentation((CharSequence)"useless entity"), "10b");
        DirectoryTestCase.assertTrue((boolean)response.getStatus().equals((Object)Status.SUCCESS_NO_CONTENT));
        response = this.handle(application, this.webSiteURL, this.testCreationFile, Method.PUT, (Representation)new StringRepresentation((CharSequence)"file entity"), "10c");
        DirectoryTestCase.assertTrue((boolean)response.getStatus().equals((Object)Status.REDIRECTION_SEE_OTHER));
        response = this.handle(application, this.webSiteURL, this.testCreationTextFile, Method.PUT, (Representation)new StringRepresentation((CharSequence)"file entity"), "10d");
        DirectoryTestCase.assertTrue((boolean)response.getStatus().equals((Object)Status.SUCCESS_CREATED));
        BioUtils.delete((File)testDirectory, (boolean)true);
        System.out.println("End of tests*********************");
    }

    private static class MyApplication
    extends Application {
        Directory directory;

        public MyApplication(File testDirectory) {
            this.directory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((File)testDirectory));
            this.directory.setNegotiatingContent(true);
        }

        public Restlet createInboundRoot() {
            return this.directory;
        }

        public Directory getDirectory() {
            return this.directory;
        }

        public void setTestDirectory(File testDirectory) {
            String rootIdentifier = LocalReference.createFileReference((File)testDirectory).getIdentifier();
            if (rootIdentifier.endsWith("/")) {
                this.directory.setRootRef(new Reference(rootIdentifier));
            } else {
                this.directory.setRootRef(new Reference(rootIdentifier + "/"));
            }
        }
    }
}

