/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.Engine;
import org.restlet.ext.jetty.HttpServerHelper;
import org.restlet.ext.net.HttpClientHelper;
import org.restlet.test.RestletTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConnectorsTestCase
extends RestletTestCase {
    private Component component;
    private final boolean enabledClientApache = true;
    private final boolean enabledClientDefault = true;
    private final boolean enabledClientJdkNet = true;
    private final boolean enabledServerDefault = true;
    private final boolean enabledServerGrizzly = true;
    private final boolean enabledServerJetty = true;
    private final boolean enabledServerNetty = false;
    private final boolean enabledServerSimple = true;

    protected abstract void call(String var1) throws Exception;

    protected abstract Application createApplication(Component var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ConnectorHelper<Server> server, ConnectorHelper<Client> client) throws Exception {
        Engine nre = new Engine(false);
        nre.getRegisteredServers().add(server);
        nre.getRegisteredClients().add(client);
        nre.registerDefaultAuthentications();
        nre.registerDefaultConverters();
        Engine.setInstance((Engine)nre);
        String uri = this.start();
        try {
            this.call(uri);
        }
        finally {
            this.stop();
        }
    }

    private String start() throws Exception {
        this.component = new Component();
        Server server = this.component.getServers().add(Protocol.HTTP, 0);
        Application application = this.createApplication(this.component);
        this.component.getDefaultHost().attach((Restlet)application);
        this.component.start();
        return "http://localhost:" + server.getEphemeralPort() + "/test";
    }

    private void stop() throws Exception {
        if (this.component != null && this.component.isStarted()) {
            this.component.stop();
        }
        this.component = null;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Engine.register();
    }

    public void testDefaultAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.engine.http.connector.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testDefaultAndDefault() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.engine.http.connector.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.engine.http.connector.HttpClientHelper(null));
    }

    public void testDefaultAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.engine.http.connector.HttpServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }

    public void testGrizzlyAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.grizzly.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testGrizzlyAndDefault() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.grizzly.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.engine.http.connector.HttpClientHelper(null));
    }

    public void testGrizzlyAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.grizzly.HttpServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }

    public void testJettyAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testJettyAndDefault() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.engine.http.connector.HttpClientHelper(null));
    }

    public void testJettyAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new HttpServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }

    public void testNettyAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
    }

    public void testNettyAndDefault() throws Exception {
        ((Object)((Object)this)).getClass();
    }

    public void testNettyAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
    }

    public void testSimpleAndApache() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.simple.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.ext.httpclient.HttpClientHelper(null));
    }

    public void testSimpleAndDefault() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.simple.HttpServerHelper(null), (ConnectorHelper<Client>)new org.restlet.engine.http.connector.HttpClientHelper(null));
    }

    public void testSimpleAndJdkNet() throws Exception {
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.runTest((ConnectorHelper<Server>)new org.restlet.ext.simple.HttpServerHelper(null), (ConnectorHelper<Client>)new HttpClientHelper(null));
    }
}

