/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.engine.http.header.CookieReader;
import org.restlet.engine.http.header.CookieSettingReader;
import org.restlet.engine.http.header.CookieSettingWriter;
import org.restlet.engine.http.header.CookieWriter;
import org.restlet.engine.util.DateUtils;
import org.restlet.test.RestletTestCase;

public class CookiesTestCase
extends RestletTestCase {
    private void testCookie(String headerValue) throws IOException {
        CookieReader cr = new CookieReader(headerValue);
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Cookie cookie = cr.readValue();
        while (cookie != null) {
            cookies.add(cookie);
            cookie = cr.readValue();
        }
        String newHeaderValue = CookieWriter.write(cookies);
        CookiesTestCase.assertEquals((String)headerValue, (String)newHeaderValue);
    }

    private void testCookieValues(String headerValue) throws IOException {
        CookieReader cr = new CookieReader(headerValue);
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Cookie cookie = cr.readValue();
        while (cookie != null) {
            cookies.add(cookie);
            cookie = cr.readValue();
        }
        String newHeaderValue = CookieWriter.write(cookies);
        ArrayList<Cookie> cookies2 = new ArrayList<Cookie>();
        cr = new CookieReader(newHeaderValue);
        cookie = cr.readValue();
        while (cookie != null) {
            cookies2.add(cookie);
            cookie = cr.readValue();
        }
        CookiesTestCase.assertEquals((int)cookies.size(), (int)cookies2.size());
        for (int i = 0; i < cookies.size(); ++i) {
            CookiesTestCase.assertEquals((String)((Cookie)cookies.get(i)).getName(), (String)((Cookie)cookies2.get(i)).getName());
            CookiesTestCase.assertEquals((String)((Cookie)cookies.get(i)).getValue(), (String)((Cookie)cookies2.get(i)).getValue());
        }
    }

    private void testCookieDate(String dateValue) {
        Date date = DateUtils.parse((String)dateValue, (List)DateUtils.FORMAT_RFC_1036);
        String newDateValue = DateUtils.format((Date)date, (String)((String)DateUtils.FORMAT_RFC_1036.get(0)));
        CookiesTestCase.assertEquals((String)dateValue, (String)newDateValue);
    }

    private void testCookieSetting(String headerValue, boolean compare) throws IOException {
        CookieSettingReader cr = new CookieSettingReader(headerValue);
        CookieSetting cookie = cr.readValue();
        String newHeaderValue = CookieSettingWriter.write((CookieSetting)cookie);
        if (compare) {
            boolean result = newHeaderValue.toLowerCase().startsWith(headerValue.toLowerCase());
            CookiesTestCase.assertTrue((boolean)result);
        }
    }

    public void testParsing() throws IOException {
        this.testCookie("CUSTOMER=WILE_E_COYOTE");
        this.testCookie("CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001");
        this.testCookie("CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001; SHIPPING=FEDEX");
        this.testCookie("NUMBER=RIDING_ROCKET_0023; PART_NUMBER=ROCKET_LAUNCHER_0001");
        this.testCookieSetting("CUSTOMER=WILE_E_COYOTE; path=/", true);
        this.testCookieSetting("PART_NUMBER=ROCKET_LAUNCHER_0001; path=/", true);
        this.testCookieSetting("SHIPPING=FEDEX; path=/foo", true);
        this.testCookieSetting("NUMBER=RIDING_ROCKET_0023; path=/ammo", true);
        this.testCookieDate("Tuesday, 09-Nov-99 23:12:40 GMT");
        this.testCookie("$Version=\"1\"; Customer=\"WILE_E_COYOTE\"; $Path=\"/acme\"");
        this.testCookie("$Version=\"1\"; Customer=\"WILE_E_COYOTE\"; $Path=\"/acme\"; Part_Number=\"Rocket_Launcher_0001\"; $Path=\"/acme\"");
        this.testCookie("$Version=\"1\"; Customer=\"WILE_E_COYOTE\"; $Path=\"/acme\"; Part_Number=\"Rocket_Launcher_0001\"; $Path=\"/acme\"; Shipping=\"FedEx\"; $Path=\"/acme\"");
        this.testCookie("$Version=\"1\"; Part_Number=\"Riding_Rocket_0023\"; $Path=\"/acme/ammo\"; Part_Number=\"Rocket_Launcher_0001\"; $Path=\"/acme\"");
        this.testCookieSetting("Customer=\"WILE_E_COYOTE\"; Version=\"1\"; Path=\"/acme\"", true);
        this.testCookieSetting("Part_Number=\"Rocket_Launcher_0001\"; Version=\"1\"; Path=\"/acme\"", true);
        this.testCookieSetting("Shipping=\"FedEx\"; Version=\"1\"; Path=\"/acme\"", true);
        this.testCookieSetting("Part_Number=\"Rocket_Launcher_0001\"; Version=\"1\"; Path=\"/acme\"", true);
        this.testCookieSetting("Part_Number=\"Riding_Rocket_0023\"; Version=\"1\"; Path=\"/acme/ammo\"", true);
        this.testCookieSetting("RMS_ADMETA_VISITOR_RMS=27756847%3A240105; expires=Thu, 02 Mar 2006 21:09:00 GMT; path=/; domain=.admeta.com", false);
        this.testCookieValues("Cookie 1=One; Cookie 2=Two; Cookie 3=Three; Cookie 4=Four; Cookie 5=\"Five\"; Cookie 6=\"Six\"");
    }
}

