/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;

@Path(value="contextTest")
public class ContextsTestService {
    @Context
    Providers providers;
    ContextResolver<Integer> contextResolver;
    @Context
    UriInfo uriInfo;

    void setProviders(Providers providers) {
        this.contextResolver = providers.getContextResolver(Integer.class, MediaType.WILDCARD_TYPE);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="fields")
    public String fieldsAvailable() {
        StringBuilder stb = new StringBuilder();
        if (this.providers != null) {
            stb.append("providers\n");
        }
        if (this.contextResolver != null) {
            stb.append("contextResolver\n");
        }
        if (this.uriInfo != null) {
            stb.append("uriInfo\n");
        }
        return stb.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="lastPathSegm")
    public String getPathSegm(@Context PathSegment lastPathSegment) {
        StringBuilder stb = new StringBuilder();
        for (String key : lastPathSegment.getMatrixParameters().keySet()) {
            stb.append(key + " : " + lastPathSegment.getMatrixParameters().get((Object)key) + "\n");
        }
        return stb.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="params")
    public String getResources(@Context UriInfo uriInfo, @Context Providers providers) {
        StringBuilder stb = new StringBuilder();
        if (providers != null) {
            stb.append("providers\n");
        }
        if (this.contextResolver != null) {
            stb.append("contextResolver\n");
        }
        if (uriInfo != null) {
            stb.append("uriInfo\n");
        }
        return stb.toString();
    }
}

