/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import junit.framework.AssertionFailedError;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.ext.jackson.JacksonConverter;
import org.restlet.ext.jaxb.JaxbRepresentation;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.jaxrs.services.others.Person;
import org.restlet.test.jaxrs.services.resources.JsonTestService;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class JsonTest
extends JaxRsTestCase {
    public static void main(String[] args) throws Exception {
        new JsonTest().runServerUntilKeyPressed();
    }

    private void checkJsonResponse(Response response) throws JSONException, IOException {
        JsonTest.sysOutEntityIfError(response);
        JsonTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        JSONObject jsonObject = new JSONObject(response.getEntity().getText());
        JsonTest.assertEquals((Object)"Angela", (Object)jsonObject.get("firstname"));
        JsonTest.assertEquals((Object)"Merkel", (Object)jsonObject.get("lastname"));
    }

    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(JsonTestService.class);
            }
        };
    }

    protected void modifyApplication(JaxRsApplication app) {
        app.getTunnelService().setExtensionsTunnel(true);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Engine.getInstance().getRegisteredConverters().add(0, new JacksonConverter());
    }

    public void testGetJsonObject() throws Exception {
        Response response = this.get("JSONObject");
        JsonTest.sysOutEntityIfError(response);
        JsonTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        try {
            JsonTest.assertEquals((String)"{\"name1\":\"value1\",\"name2\":\"value2\"}", (String)entity);
        }
        catch (AssertionFailedError afe) {
            JsonTest.assertEquals((String)"{\"name2\":\"value2\",\"name1\":\"value1\"}", (String)entity);
        }
    }

    public void testGetPersonJson() throws Exception {
        Response response = this.get("person?firstname=Angela&lastname=Merkel", MediaType.APPLICATION_JSON);
        this.checkJsonResponse(response);
        response = this.get("person.json?firstname=Angela&lastname=Merkel", MediaType.TEXT_XML);
        this.checkJsonResponse(response);
        response = this.get("person.json?firstname=Angela&lastname=Merkel", MediaType.IMAGE_GIF);
        this.checkJsonResponse(response);
    }

    private void testGetPersonXml(MediaType xmlMediaType) throws IOException {
        Response response = this.get("person?firstname=Angela&lastname=Merkel", xmlMediaType);
        JsonTest.sysOutEntityIfError(response);
        JsonTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        JaxbRepresentation jaxbReprs = new JaxbRepresentation(response.getEntity(), Person.class);
        Person person = (Person)jaxbReprs.getObject();
        JsonTest.assertEquals((String)"Angela", (String)person.getFirstname());
        JsonTest.assertEquals((String)"Merkel", (String)person.getLastname());
    }

    public void testGetPersonXmlA() throws Exception {
        this.testGetPersonXml(MediaType.APPLICATION_XML);
    }

    public void testGetPersonXmlT() throws Exception {
        this.testGetPersonXml(MediaType.TEXT_XML);
    }

    public void testPost() throws Exception {
        StringRepresentation entity = new StringRepresentation((CharSequence)"{name:value}", MediaType.APPLICATION_JSON);
        Response response = this.post("JSONObject", (Representation)entity);
        JsonTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        JsonTest.assertEquals((String)"value", (String)response.getEntity().getText());
    }

    public void testString() throws Exception {
        Response response = this.get("String");
        JsonTest.sysOutEntityIfError(response);
        JsonTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        JsonTest.assertEquals((String)"{name:value}", (String)entity.getText());
    }
}

