/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.restlet.data.Reference;
import org.restlet.engine.util.AlphaNumericComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaNumericComparatorTestCase
extends TestCase {
    private static List<Reference> unsorted = AlphaNumericComparatorTestCase.refs("1", "2", "3", "1.0", "1.1", "1.1.1", "2.0", "2.2", "2.2.2", "3.0", "3.3");
    private static List<Reference> expected = AlphaNumericComparatorTestCase.refs("1", "1.0", "1.1", "1.1.1", "2", "2.0", "2.2", "2.2.2", "3", "3.0", "3.3");

    private static List<Reference> refs(String ... uris) {
        LinkedList<Reference> result = new LinkedList<Reference>();
        for (String uri : uris) {
            result.add(new Reference(uri));
        }
        return result;
    }

    public void testBug() {
        ArrayList<Reference> result = new ArrayList<Reference>(unsorted);
        Collections.sort(result, new AlphaNumericComparator());
        Assert.assertEquals(expected, result);
    }
}

