/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.restlet.test.engine.BaseConnectorsTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChunkedEncodingTestCase
extends BaseConnectorsTestCase {
    private static int LOOP_NUMBER = 50;
    boolean checkedForChunkedResponse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void assertXML(DomRepresentation entity) {
        try {
            Document document = entity.getDocument();
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            ChunkedEncodingTestCase.assertEquals((String)"root", (String)root.getNodeName());
            ChunkedEncodingTestCase.assertEquals((int)2, (int)children.getLength());
            ChunkedEncodingTestCase.assertEquals((String)"child-0", (String)children.item(0).getNodeName());
            ChunkedEncodingTestCase.assertEquals((String)"name-0", (String)children.item(0).getAttributes().getNamedItem("name").getNodeValue());
            ChunkedEncodingTestCase.assertEquals((String)"child-1", (String)children.item(1).getNodeName());
            ChunkedEncodingTestCase.assertEquals((String)"name-1", (String)children.item(1).getAttributes().getNamedItem("name").getNodeValue());
        }
        catch (IOException ex) {
            ChunkedEncodingTestCase.fail((String)ex.getMessage());
        }
        finally {
            entity.release();
        }
    }

    static void checkForChunkedHeader(Message message) {
        Form parameters = (Form)message.getAttributes().get("org.restlet.http.headers");
        Parameter p = parameters.getFirst("Transfer-Encoding");
        ChunkedEncodingTestCase.assertFalse((p == null ? 1 : 0) != 0);
        ChunkedEncodingTestCase.assertEquals((String)"chunked", (String)p.getValue());
    }

    private static Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Representation createTestXml() {
        Document doc = ChunkedEncodingTestCase.createDocument();
        Element root = doc.createElement("root");
        doc.appendChild(root);
        for (int i = 0; i < 2; ++i) {
            Element e = doc.createElement("child-" + i);
            e.setAttribute("name", "name-" + i);
            root.appendChild(e);
        }
        StringRepresentation rep = null;
        try {
            rep = new StringRepresentation((CharSequence)new DomRepresentation(MediaType.TEXT_XML, doc).getText());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        rep.setSize(-1L);
        return rep;
    }

    protected void call(String uri) throws Exception {
        for (int i = 0; i < LOOP_NUMBER; ++i) {
            this.sendGet(uri);
            this.sendPut(uri);
        }
    }

    protected Application createApplication(Component component) {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attach("/test", PutTestResource.class);
                return router;
            }
        };
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGet(String uri) throws Exception {
        Request request = new Request(Method.GET, uri);
        Client c = new Client(Protocol.HTTP);
        Response r = c.handle(request);
        try {
            ChunkedEncodingTestCase.assertEquals((String)r.getStatus().getDescription(), (Object)Status.SUCCESS_OK, (Object)r.getStatus());
            ChunkedEncodingTestCase.assertXML(new DomRepresentation(r.getEntity()));
        }
        finally {
            r.release();
            c.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPut(String uri) throws Exception {
        Request request = new Request(Method.PUT, uri, ChunkedEncodingTestCase.createTestXml());
        Client c = new Client(Protocol.HTTP);
        Response r = c.handle(request);
        try {
            if (this.checkedForChunkedResponse) {
                ChunkedEncodingTestCase.checkForChunkedHeader((Message)r);
            }
            ChunkedEncodingTestCase.assertEquals((String)r.getStatus().getDescription(), (Object)Status.SUCCESS_OK, (Object)r.getStatus());
            ChunkedEncodingTestCase.assertXML(new DomRepresentation(r.getEntity()));
        }
        finally {
            r.release();
            c.stop();
        }
    }

    public void setUp() {
        this.checkedForChunkedResponse = true;
    }

    public void testJettyAndApache() throws Exception {
        super.testJettyAndApache();
    }

    public void testJettyAndDefault() throws Exception {
        this.checkedForChunkedResponse = false;
        super.testJettyAndDefault();
    }

    public void testNettyAndApache() throws Exception {
        this.checkedForChunkedResponse = false;
        super.testNettyAndApache();
    }

    public void testNettyAndDefault() throws Exception {
        this.checkedForChunkedResponse = false;
        super.testNettyAndDefault();
    }

    public void testNettyAndJdkNet() throws Exception {
        this.checkedForChunkedResponse = false;
        super.testNettyAndJdkNet();
    }

    public void testSimpleAndDefault() throws Exception {
        this.checkedForChunkedResponse = false;
        super.testSimpleAndDefault();
    }

    public void testSimpleAndJdkNet() throws Exception {
        super.testSimpleAndJdkNet();
    }

    public static class PutTestResource
    extends ServerResource {
        public PutTestResource() {
            this.getVariants().add(new Variant(MediaType.TEXT_XML));
            this.setNegotiated(false);
        }

        public Representation get() {
            return ChunkedEncodingTestCase.createTestXml();
        }

        public Representation put(Representation entity) {
            ChunkedEncodingTestCase.checkForChunkedHeader((Message)this.getRequest());
            DomRepresentation dom = new DomRepresentation(entity);
            DomRepresentation rep = null;
            try {
                Document doc = dom.getDocument();
                ChunkedEncodingTestCase.assertXML(dom);
                rep = new DomRepresentation(MediaType.TEXT_XML, doc);
                this.getResponse().setEntity((Representation)rep);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Assert.fail((String)ex.getMessage());
            }
            return rep;
        }
    }
}

