/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Form;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.engine.io.BioUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Directory;
import org.restlet.routing.Router;
import org.restlet.test.RestletTestCase;

public class RangeTestCase
extends RestletTestCase {
    private static final File testDir = new File(System.getProperty("java.io.tmpdir"), "rangeTestCase");
    private Component component;

    protected void setUp() throws Exception {
        this.component = new Component();
        this.component.getServers().add(Protocol.HTTP, TEST_PORT);
        this.component.getClients().add(Protocol.FILE);
        this.component.getDefaultHost().attach((Restlet)new TestRangeApplication());
        this.component.start();
    }

    protected void tearDown() throws Exception {
        this.component.stop();
        this.component = null;
    }

    @Test
    public void testGet() throws Exception {
        Client client = new Client(Protocol.HTTP);
        Request request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/testGet");
        Response response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"1234567890", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)10L, (long)response.getEntity().getSize());
        request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/testGet");
        request.setRanges(Arrays.asList(new Range(0L, 10L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"1234567890", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)10L, (long)response.getEntity().getSize());
        RangeTestCase.assertEquals((long)0L, (long)response.getEntity().getRange().getIndex());
        RangeTestCase.assertEquals((long)10L, (long)response.getEntity().getRange().getSize());
        request.setRanges(Arrays.asList(new Range(0L, 2L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"12", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)2L, (long)response.getEntity().getSize());
        RangeTestCase.assertEquals((long)0L, (long)response.getEntity().getRange().getIndex());
        RangeTestCase.assertEquals((long)2L, (long)response.getEntity().getRange().getSize());
        request.setRanges(Arrays.asList(new Range(2L, 2L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"34", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)2L, (long)response.getEntity().getSize());
        RangeTestCase.assertEquals((long)2L, (long)response.getEntity().getRange().getIndex());
        RangeTestCase.assertEquals((long)2L, (long)response.getEntity().getRange().getSize());
        request.setRanges(Arrays.asList(new Range(2L, 7L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"3456789", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)7L, (long)response.getEntity().getSize());
        RangeTestCase.assertEquals((long)2L, (long)response.getEntity().getRange().getIndex());
        RangeTestCase.assertEquals((long)7L, (long)response.getEntity().getRange().getSize());
        request.setRanges(Arrays.asList(new Range(-1L, 7L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"4567890", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)7L, (long)response.getEntity().getSize());
        RangeTestCase.assertEquals((long)3L, (long)response.getEntity().getRange().getIndex());
        RangeTestCase.assertEquals((long)7L, (long)response.getEntity().getRange().getSize());
        request.setRanges(Arrays.asList(new Range(1L, -1L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"234567890", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)9L, (long)response.getEntity().getSize());
        RangeTestCase.assertEquals((long)1L, (long)response.getEntity().getRange().getIndex());
        RangeTestCase.assertEquals((long)9L, (long)response.getEntity().getRange().getSize());
        client.stop();
    }

    @Test
    public void testConditionalRanges() throws Exception {
        Client client = new Client(Protocol.HTTP);
        Request request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/testGet");
        Response response = client.handle(request);
        Tag entityTag = response.getEntity().getTag();
        request.setRanges(Arrays.asList(new Range(1L, -1L)));
        request.getConditions().setRangeTag(entityTag);
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"234567890", (String)response.getEntity().getText());
        RangeTestCase.assertEquals((long)9L, (long)response.getEntity().getSize());
        RangeTestCase.assertEquals((long)1L, (long)response.getEntity().getRange().getIndex());
        RangeTestCase.assertEquals((long)9L, (long)response.getEntity().getRange().getSize());
        entityTag = new Tag(entityTag.getName() + "-test");
        request.setRanges(Arrays.asList(new Range(1L, -1L)));
        request.getConditions().setRangeTag(entityTag);
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"1234567890", (String)response.getEntity().getText());
        client.stop();
    }

    @Test
    public void testPut() throws IOException {
        BioUtils.delete((File)testDir, (boolean)true);
        Client client = new Client(Protocol.HTTP);
        Request request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/testPut/essai.txt");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"1234567890"));
        request.setRanges(Arrays.asList(new Range(0L, 10L)));
        Response response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = client.handle(new Request(Method.GET, request.getResourceRef()));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"1234567890", (String)response.getEntity().getText());
        request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/testPut/essai.txt");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"0000000000"));
        request.setRanges(Arrays.asList(new Range(1L, 10L)));
        response = client.handle(request);
        System.out.println(response.getStatus() + " / " + response.getStatus().getThrowable());
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = client.handle(new Request(Method.GET, request.getResourceRef()));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"10000000000", (String)response.getEntity().getText());
        request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/testPut/essai2.txt");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"0000000000"));
        request.setRanges(Arrays.asList(new Range(1L, 10L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        request.setMethod(Method.GET);
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"0000000000", (String)response.getEntity().getText());
        request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/testPut/essai.txt");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"22"));
        request.setRanges(Arrays.asList(new Range(2L, 2L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = client.handle(new Request(Method.GET, request.getResourceRef()));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"10220000000", (String)response.getEntity().getText());
        request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/testPut/essai.txt");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"888"));
        request.setRanges(Arrays.asList(new Range(8L, -1L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = client.handle(new Request(Method.GET, request.getResourceRef()));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"10220000888", (String)response.getEntity().getText());
        request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/testPut/essai3.txt");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"888"));
        request.setRanges(Arrays.asList(new Range(8L, -1L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        request.setMethod(Method.GET);
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"888", (String)response.getEntity().getText());
        request = new Request(Method.PUT, "http://localhost:" + TEST_PORT + "/testPut/essai.txt");
        request.setEntity((Representation)new StringRepresentation((CharSequence)"99"));
        request.setRanges(Arrays.asList(new Range(8L, -1L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        response = client.handle(new Request(Method.GET, request.getResourceRef()));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"10220000998", (String)response.getEntity().getText());
        request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/testPut/essai.txt");
        request.setRanges(Arrays.asList(new Range(3L, -1L)));
        response = client.handle(request);
        RangeTestCase.assertEquals((Object)Status.SUCCESS_PARTIAL_CONTENT, (Object)response.getStatus());
        RangeTestCase.assertEquals((String)"20000998", (String)response.getEntity().getText());
        BioUtils.delete((File)testDir, (boolean)true);
    }

    @Test
    public void testRanges() throws Exception {
        Client client = new Client(Protocol.HTTP);
        Request request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/test?range=0-500");
        request.setRanges(Arrays.asList(new Range(0L, 500L)));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)client.handle(request).getStatus());
        request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/test?range=-500");
        request.setRanges(Arrays.asList(new Range(-1L, 500L)));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)client.handle(request).getStatus());
        request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/test?range=500-");
        request.setRanges(Arrays.asList(new Range(500L, -1L)));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)client.handle(request).getStatus());
        request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/test?range=500-1000");
        request.setRanges(Arrays.asList(new Range(500L, 500L)));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)client.handle(request).getStatus());
        request = new Request(Method.GET, "http://localhost:" + TEST_PORT + "/test?range=500-1000&range=500-");
        request.setRanges(Arrays.asList(new Range(500L, 500L), new Range(500L, -1L)));
        RangeTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)client.handle(request).getStatus());
        client.stop();
    }

    private static class TestRangeRestlet
    extends Restlet {
        private TestRangeRestlet() {
        }

        public void handle(Request request, Response response) {
            Form form = request.getResourceRef().getQueryAsForm();
            List ranges = request.getRanges();
            boolean match = false;
            for (Parameter parameter : form) {
                Range range;
                long index = 0L;
                long length = 0L;
                String value = parameter.getValue();
                if (value.startsWith("-")) {
                    index = -1L;
                    length = Long.parseLong(value.substring(1));
                } else if (value.endsWith("-")) {
                    index = Long.parseLong(value.substring(0, value.length() - 1));
                    length = -1L;
                } else {
                    String[] tab = value.split("-");
                    if (tab.length == 2) {
                        index = Long.parseLong(tab[0]);
                        length = Long.parseLong(tab[1]) - index;
                    }
                }
                boolean found = false;
                Iterator i$ = ranges.iterator();
                while (i$.hasNext() && !(found = index == (range = (Range)i$.next()).getIndex() && length == range.getSize())) {
                }
                if (!found) break;
                match = true;
            }
            if (match) {
                response.setStatus(Status.SUCCESS_OK);
            } else {
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            }
        }
    }

    private static class TestRangeGetRestlet
    extends Restlet {
        private TestRangeGetRestlet() {
        }

        public void handle(Request request, Response response) {
            response.setEntity((Representation)new StringRepresentation((CharSequence)"1234567890"));
            response.getEntity().setTag(new Tag("TestRangeGetRestlet"));
        }
    }

    private static class TestRangeApplication
    extends Application {
        public TestRangeApplication() {
            this.getRangeService().setEnabled(true);
        }

        public Restlet createInboundRoot() {
            Router router = new Router();
            router.attach("/test", (Restlet)new TestRangeRestlet());
            router.attach("/testGet", (Restlet)new TestRangeGetRestlet());
            Directory directory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((File)testDir));
            directory.setModifiable(true);
            router.attach("/testPut/", (Restlet)directory);
            return router;
        }
    }
}

