/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.restlet.test.engine.BaseConnectorsTestCase;

public class ChunkedEncodingPutTestCase
extends BaseConnectorsTestCase {
    private static int LOOP_NUMBER = 20;

    private static Representation createChunkedRepresentation(int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append("a");
        }
        StringRepresentation rep = new StringRepresentation((CharSequence)builder.toString(), MediaType.TEXT_PLAIN);
        rep.setSize(-1L);
        return rep;
    }

    protected void call(String uri) throws Exception {
        int i;
        for (i = 0; i < LOOP_NUMBER; ++i) {
            this.sendPut(uri, 10);
        }
        for (i = 0; i < LOOP_NUMBER; ++i) {
            this.sendPut(uri, 50000);
        }
        this.sendPut(uri, 10);
    }

    protected Application createApplication(Component component) {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attach("/test", PutTestResource.class);
                return router;
            }
        };
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPut(String uri, int size) throws Exception {
        Request request = new Request(Method.PUT, uri, ChunkedEncodingPutTestCase.createChunkedRepresentation(size));
        Client c = new Client(Protocol.HTTP);
        Response r = c.handle(request);
        try {
            if (!r.getStatus().isSuccess()) {
                System.out.println(r.getStatus());
            }
            ChunkedEncodingPutTestCase.assertNotNull((Object)r.getEntity());
            ChunkedEncodingPutTestCase.assertEquals((String)ChunkedEncodingPutTestCase.createChunkedRepresentation(size).getText(), (String)r.getEntity().getText());
        }
        finally {
            r.release();
            c.stop();
        }
    }

    public static class PutTestResource
    extends ServerResource {
        public PutTestResource() {
            this.getVariants().add(new Variant(MediaType.TEXT_XML));
            this.setNegotiated(false);
        }

        public Representation put(Representation entity) {
            return entity;
        }
    }
}

