/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.sip;

import junit.framework.TestCase;
import org.junit.Test;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.ext.sip.internal.SipRecipientInfoReader;

public class SipRecipientInfoTestCase
extends TestCase {
    @Test
    public void testParsing() throws Exception {
        String str = "SIP/2.0/UDP 192.0.2.1:5060 ;received=192.0.2.207;branch=z9hG4bK77asjd";
        SipRecipientInfoReader r = new SipRecipientInfoReader(str);
        SipRecipientInfo s = r.readValue();
        SipRecipientInfoTestCase.assertEquals((Object)Protocol.SIP, (Object)s.getProtocol());
        SipRecipientInfoTestCase.assertEquals((String)"UDP", (String)s.getTransport());
        SipRecipientInfoTestCase.assertEquals((String)"192.0.2.1:5060", (String)s.getName());
        SipRecipientInfoTestCase.assertEquals((int)2, (int)s.getParameters().size());
        Parameter parameter = (Parameter)s.getParameters().get(0);
        SipRecipientInfoTestCase.assertEquals((String)"received", (String)parameter.getName());
        SipRecipientInfoTestCase.assertEquals((String)"192.0.2.207", (String)parameter.getValue());
        parameter = (Parameter)s.getParameters().get(1);
        SipRecipientInfoTestCase.assertEquals((String)"branch", (String)parameter.getName());
        SipRecipientInfoTestCase.assertEquals((String)"z9hG4bK77asjd", (String)parameter.getValue());
        SipRecipientInfoTestCase.assertNull((Object)s.getComment());
        str = "SIP/2.0/UDP 192.0.2.1:5060 ;received=192.0.2.207;branch=z9hG4bK77asjd (this is a comment)";
        r = new SipRecipientInfoReader(str);
        s = r.readValue();
        SipRecipientInfoTestCase.assertEquals((Object)Protocol.SIP, (Object)s.getProtocol());
        SipRecipientInfoTestCase.assertEquals((String)"UDP", (String)s.getTransport());
        SipRecipientInfoTestCase.assertEquals((String)"192.0.2.1:5060", (String)s.getName());
        SipRecipientInfoTestCase.assertEquals((int)2, (int)s.getParameters().size());
        parameter = (Parameter)s.getParameters().get(0);
        SipRecipientInfoTestCase.assertEquals((String)"received", (String)parameter.getName());
        SipRecipientInfoTestCase.assertEquals((String)"192.0.2.207", (String)parameter.getValue());
        parameter = (Parameter)s.getParameters().get(1);
        SipRecipientInfoTestCase.assertEquals((String)"branch", (String)parameter.getName());
        SipRecipientInfoTestCase.assertEquals((String)"z9hG4bK77asjd", (String)parameter.getValue());
        SipRecipientInfoTestCase.assertEquals((String)"this is a comment", (String)s.getComment());
        str = "SIP/2.0/TCP 127.0.0.1:5061;branch=z9hG4bK-6503-1-0";
        r = new SipRecipientInfoReader(str);
        s = r.readValue();
        SipRecipientInfoTestCase.assertEquals((Object)Protocol.SIP, (Object)s.getProtocol());
        SipRecipientInfoTestCase.assertEquals((String)"TCP", (String)s.getTransport());
        SipRecipientInfoTestCase.assertEquals((String)"127.0.0.1:5061", (String)s.getName());
        SipRecipientInfoTestCase.assertEquals((int)1, (int)s.getParameters().size());
        parameter = (Parameter)s.getParameters().get(0);
        SipRecipientInfoTestCase.assertEquals((String)"branch", (String)parameter.getName());
        SipRecipientInfoTestCase.assertEquals((String)"z9hG4bK-6503-1-0", (String)parameter.getValue());
        str = "SIP/2.0/TCP [fe80::223:dfff:fe7f:7b1a%en0]:5061;branch=z9hG4bK-409-1-0";
        r = new SipRecipientInfoReader(str);
        s = r.readValue();
        SipRecipientInfoTestCase.assertEquals((Object)Protocol.SIP, (Object)s.getProtocol());
        SipRecipientInfoTestCase.assertEquals((String)"TCP", (String)s.getTransport());
        SipRecipientInfoTestCase.assertEquals((String)"[fe80::223:dfff:fe7f:7b1a%en0]:5061", (String)s.getName());
        SipRecipientInfoTestCase.assertEquals((int)1, (int)s.getParameters().size());
        parameter = (Parameter)s.getParameters().get(0);
        SipRecipientInfoTestCase.assertEquals((String)"branch", (String)parameter.getName());
        SipRecipientInfoTestCase.assertEquals((String)"z9hG4bK-409-1-0", (String)parameter.getValue());
        SipRecipientInfoTestCase.assertNull((Object)s.getComment());
    }
}

