/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.ReferenceList;
import org.restlet.data.Status;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.LocalClientHelper;
import org.restlet.engine.local.ZipEntryEntity;
import org.restlet.representation.Representation;
import org.restlet.service.MetadataService;

public class ZipClientHelper
extends LocalClientHelper {
    public ZipClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.ZIP);
        this.getProtocols().add(Protocol.JAR);
    }

    protected void handleLocal(Request request, Response response, String decodedPath) {
        String entryName;
        String fileUri;
        int spi = decodedPath.indexOf("!/");
        if (spi != -1) {
            fileUri = decodedPath.substring(0, spi);
            entryName = decodedPath.substring(spi + 2);
        } else {
            fileUri = decodedPath;
            entryName = "";
        }
        LocalReference fileRef = new LocalReference(fileUri);
        if (Protocol.FILE.equals(fileRef.getSchemeProtocol())) {
            File file = fileRef.getFile();
            if (Method.GET.equals(request.getMethod()) || Method.HEAD.equals(request.getMethod())) {
                this.handleGet(request, response, file, entryName, this.getMetadataService());
            } else if (Method.PUT.equals(request.getMethod())) {
                this.handlePut(request, response, file, entryName);
            } else {
                response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                response.getAllowedMethods().add(Method.GET);
                response.getAllowedMethods().add(Method.HEAD);
                response.getAllowedMethods().add(Method.PUT);
            }
        } else {
            response.setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED, "Only works on local files.");
        }
    }

    protected void handleGet(Request request, Response response, File file, String entryName, MetadataService metadataService) {
        if (!file.exists()) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else {
            ZipFile zipFile;
            try {
                zipFile = new ZipFile(file);
            }
            catch (Exception e) {
                response.setStatus(Status.SERVER_ERROR_INTERNAL, e);
                return;
            }
            ZipEntryEntity entity = new ZipEntryEntity(zipFile, entryName, metadataService);
            if (!((Entity)entity).exists()) {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            } else {
                Representation output;
                if (((Entity)entity).isDirectory()) {
                    List<Entity> children = ((Entity)entity).getChildren();
                    ReferenceList rl = new ReferenceList(children.size());
                    String fileUri = LocalReference.createFileReference(file).toString();
                    String scheme = request.getResourceRef().getScheme();
                    String baseUri = scheme + ":" + fileUri + "!/";
                    for (Entity entry : children) {
                        rl.add(baseUri + entry.getName());
                    }
                    output = rl.getTextRepresentation();
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {}
                } else {
                    output = ((Entity)entity).getRepresentation(metadataService.getDefaultMediaType(), this.getTimeToLive());
                    output.setLocationRef(request.getResourceRef());
                    Entity.updateMetadata(((Entity)entity).getName(), output, true, this.getMetadataService());
                }
                response.setStatus(Status.SUCCESS_OK);
                response.setEntity(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handlePut(Request request, Response response, File file, String entryName) {
        zipExists = file.exists();
        zipOut = null;
        if ("".equals(entryName) && request.getEntity() != null && request.getEntity().getDisposition() != null) {
            entryName = request.getEntity().getDisposition().getFilename();
        }
        if (entryName == null) {
            response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Must specify an entry name.");
            return;
        }
        canAppend = zipExists == false;
        isDirectory = entryName.endsWith("/");
        wrongReplace = false;
        try {
            if (zipExists) {
                zipFile = new ZipFile(file);
                canAppend &= null == zipFile.getEntry(entryName);
                wrongReplace = isDirectory != false ? null != zipFile.getEntry(entryName.substring(0, entryName.length() - 1)) : null != zipFile.getEntry(entryName + "/");
                canAppend &= wrongReplace == false;
                zipFile.close();
            }
            entity = isDirectory != false ? null : request.getEntity();
            if (canAppend) {
                block32: {
                    try {
                        zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        this.writeEntityStream(entity, zipOut, entryName);
                        zipOut.close();
                        var13_12 = null;
                        ** if (zipOut == null) goto lbl-1000
                    }
                    catch (Throwable var12_18) {
                        var13_14 = null;
                        if (zipOut == null) throw var12_18;
                        zipOut.close();
                        throw var12_18;
                    }
lbl-1000:
                    // 1 sources

                    {
                        zipOut.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block32;
                        catch (Exception e) {
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, e);
                            var13_13 = null;
                            if (zipOut == null) return;
                            zipOut.close();
                            return;
                        }
                    }
                }
                response.setStatus(Status.SUCCESS_CREATED);
                return;
            }
            if (wrongReplace) {
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Directory cannot be replace by a file or file by a directory.");
                return;
            }
            writeTo = null;
            zipFile = null;
            try {
                writeTo = File.createTempFile("restlet_zip_", "zip");
                zipFile = new ZipFile(file);
                zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(writeTo)));
                entries = zipFile.entries();
                replaced = false;
                while (entries.hasMoreElements()) {
                    e = entries.nextElement();
                    if (!replaced && entryName.equals(e.getName())) {
                        this.writeEntityStream(entity, zipOut, entryName);
                        replaced = true;
                        continue;
                    }
                    zipOut.putNextEntry(e);
                    BioUtils.copy((InputStream)new BufferedInputStream(zipFile.getInputStream(e)), zipOut);
                    zipOut.closeEntry();
                }
                if (!replaced) {
                    this.writeEntityStream(entity, zipOut, entryName);
                }
                zipFile.close();
                zipOut.close();
                var17_23 = null;
            }
            catch (Throwable var16_29) {
                var17_24 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    v0 = null;
                }
                catch (Throwable var18_26) {
                    v0 = var19_28 = null;
                }
                if (zipOut == null) throw var16_29;
                zipOut.close();
                throw var16_29;
            }
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                v1 = null;
            }
            catch (Throwable var18_25) {
                v1 = var19_27 = null;
            }
            if (zipOut != null) {
                zipOut.close();
            }
            if (!BioUtils.delete(file) || !writeTo.renameTo(file)) {
                if (!file.exists()) {
                    file.createNewFile();
                }
                fis = null;
                fos = null;
                try {
                    fis = new FileInputStream(writeTo);
                    fos = new FileOutputStream(file);
                    BioUtils.copy((InputStream)fis, fos);
                    response.setStatus(Status.SUCCESS_OK);
                    var21_30 = null;
                }
                catch (Throwable var20_38) {
                    var21_31 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        var23_34 = null;
                        if (fos == null) throw var20_38;
                    }
                    catch (Throwable var22_37) {
                        var23_35 = null;
                        if (fos == null) throw var22_37;
                        fos.close();
                        throw var22_37;
                    }
                    fos.close();
                    {
                        throw var20_38;
                    }
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    var23_32 = null;
                    if (fos == null) return;
                }
                catch (Throwable var22_36) {
                    var23_33 = null;
                    if (fos == null) throw var22_36;
                    fos.close();
                    throw var22_36;
                }
                fos.close();
                return;
            }
            response.setStatus(Status.SUCCESS_OK);
            return;
        }
        catch (Exception e) {
            response.setStatus(Status.SERVER_ERROR_INTERNAL, e);
            return;
        }
    }

    private boolean writeEntityStream(Representation entity, ZipOutputStream out, String entryName) throws IOException {
        if (entity != null && !entryName.endsWith("/")) {
            ZipEntry entry = new ZipEntry(entryName);
            if (entity.getModificationDate() != null) {
                entry.setTime(entity.getModificationDate().getTime());
            } else {
                entry.setTime(System.currentTimeMillis());
            }
            out.putNextEntry(entry);
            BioUtils.copy((InputStream)new BufferedInputStream(entity.getStream()), out);
            out.closeEntry();
            return true;
        }
        out.putNextEntry(new ZipEntry(entryName));
        out.closeEntry();
        return false;
    }
}

