/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;

public class ReadableEntityChannel
extends SelectableChannel
implements ReadableByteChannel {
    private volatile ByteBuffer remainingBuffer;
    private volatile SelectableChannel source;
    private volatile long availableSize;

    public ReadableEntityChannel(ByteBuffer remainingBuffer, SelectableChannel source, long availableSize) {
        this.remainingBuffer = remainingBuffer;
        this.source = source;
        this.availableSize = availableSize;
    }

    public Object blockingLock() {
        return this.getSource().blockingLock();
    }

    public SelectableChannel configureBlocking(boolean block) throws IOException {
        return this.getSource().configureBlocking(block);
    }

    private SelectableChannel getSource() {
        return this.source;
    }

    protected void implCloseChannel() throws IOException {
    }

    public boolean isBlocking() {
        return this.getSource().isBlocking();
    }

    public boolean isRegistered() {
        return this.getSource().isRegistered();
    }

    public SelectionKey keyFor(Selector sel) {
        return this.getSource().keyFor(sel);
    }

    public SelectorProvider provider() {
        return this.getSource().provider();
    }

    public int read(ByteBuffer dst) throws IOException {
        int result = -1;
        if (this.availableSize > 0L) {
            if (this.remainingBuffer != null && this.remainingBuffer.hasRemaining()) {
                result = Math.min(this.remainingBuffer.remaining(), dst.remaining());
                byte[] src = new byte[result];
                this.remainingBuffer.get(src);
                dst.put(src);
            } else {
                result = ((ReadableByteChannel)((Object)this.getSource())).read(dst);
            }
            if (result > 0) {
                this.availableSize -= (long)result;
            }
        }
        return result;
    }

    public SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        return this.getSource().register(sel, ops, att);
    }

    public int validOps() {
        return this.getSource().validOps();
    }
}

