/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Status;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.HttpServerOutboundWay;
import org.restlet.engine.connector.ServerInboundWay;
import org.restlet.engine.io.IoState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerInboundWay
extends ServerInboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpServerInboundWay(Connection<Server> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    protected Response createResponse(Request request) {
        return new Response(request);
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.getMessages().isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onInboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    protected void onReceived(Response message) throws IOException {
        if (message.getRequest() != null && message.getRequest().isExpectingResponse()) {
            this.getMessages().add(message);
        }
        super.onReceived(message);
    }

    @Override
    public void onTimeOut() {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onInboundError(Status.CONNECTOR_ERROR_COMMUNICATION, rsp);
        }
        super.onTimeOut();
    }

    @Override
    public void updateState() {
        Queue<Response> outboundMessages = ((HttpServerOutboundWay)this.getConnection().getOutboundWay()).getMessages();
        if (this.getIoState() == IoState.IDLE && this.getMessages().isEmpty() && outboundMessages.isEmpty()) {
            this.setIoState(IoState.INTEREST);
        }
        super.updateState();
    }
}

