/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;

public abstract class StreamRepresentation
extends Representation {
    public StreamRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    @Override
    public ReadableByteChannel getChannel() throws IOException {
        return NioUtils.getChannel(this.getStream());
    }

    @Override
    public Reader getReader() throws IOException {
        return BioUtils.getReader(this.getStream(), this.getCharacterSet());
    }

    @Override
    public void write(WritableByteChannel writableChannel) throws IOException {
        OutputStream os = NioUtils.getStream(writableChannel);
        this.write(os);
        os.flush();
    }

    @Override
    public void write(Writer writer) throws IOException {
        OutputStream os = BioUtils.getOutputStream(writer, this.getCharacterSet());
        this.write(os);
        os.flush();
    }
}

