/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.rest.ch3;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Response;
import org.restlet.example.book.rest.ch3.S3Authorized;
import org.restlet.example.book.rest.ch3.S3Bucket;
import org.restlet.resource.DomRepresentation;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3App
extends S3Authorized {
    public static void main(String ... args) {
        for (S3Bucket bucket : new S3App().getBuckets()) {
            System.out.println(bucket.getName() + " : " + bucket.getUri());
        }
    }

    public List<S3Bucket> getBuckets() {
        ArrayList<S3Bucket> result = new ArrayList<S3Bucket>();
        Response response = S3App.authorizedGet("https://s3.amazonaws.com/");
        DomRepresentation document = response.getEntityAsDom();
        if (response.getStatus().isSuccess()) {
            for (Node node : document.getNodes("//Bucket/Name")) {
                result.add(new S3Bucket(node.getTextContent()));
            }
        } else {
            System.out.println("Unable to access to your S3 buckets : " + response.getStatus());
        }
        return result;
    }
}

