/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.rest.ch3;

import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.example.book.rest.ch3.S3Authorized;
import org.restlet.example.book.rest.ch3.S3Bucket;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;

public class S3Object
extends S3Authorized {
    private final S3Bucket bucket;
    private Variant metadata;
    private String name;

    public S3Object(S3Bucket bucket, String name) {
        this.bucket = bucket;
        this.name = name;
    }

    public Status delete() {
        return S3Object.authorizedDelete(this.getUri()).getStatus();
    }

    public S3Bucket getBucket() {
        return this.bucket;
    }

    public Variant getMetadata() {
        if (this.metadata == null) {
            this.metadata = S3Object.authorizedHead(this.getUri()).getEntity();
        }
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.getBucket().getUri() + "/" + Reference.encode((String)this.getName());
    }

    public Representation getValue() {
        return S3Object.authorizedGet(this.getUri()).getEntity();
    }

    public Status save(Representation value) {
        this.metadata = value;
        return S3Object.authorizedPut(this.getUri(), value).getStatus();
    }

    public void setName(String name) {
        this.name = name;
    }
}

