/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.rest.ch7;

import org.restlet.Client;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class ApplicationTest {
    public static final String APPLICATION_URI = "http://localhost:3000/v1";

    public static void deleteBookmark(String userName, String password, String uri) {
        Request request = ApplicationTest.getAuthenticatedRequest(Method.DELETE, ApplicationTest.getBookmarkUri(userName, uri), userName, password);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus() + " : " + resp.getLocationRef());
    }

    public static void deleteUser(String userName, String password) {
        Request request = ApplicationTest.getAuthenticatedRequest(Method.DELETE, ApplicationTest.getUserUri(userName), userName, password);
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus() + " : " + resp.getLocationRef());
    }

    public static Request getAuthenticatedRequest(Method method, String uri, String login, String password) {
        Request request = new Request(method, uri);
        request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, login, password));
        return request;
    }

    public static String getBookmarkUri(String userName, String uri) {
        return "http://localhost:3000/v1/users/" + userName + "/bookmarks/" + uri;
    }

    public static String getUserUri(String name) {
        return "http://localhost:3000/v1/users/" + name;
    }

    public static void main(String ... args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage depends on the number of arguments:");
            System.out.println(" - Deletes a user     : userName, password");
            System.out.println(" - Deletes a bookmark : userName, password, URI");
            System.out.println(" - Adds a new user    : userName, password, \"full name\", email");
            System.out.println(" - Adds a new bookmark: userName, password, URI, shortDescription, longDescription, restrict");
        } else if (args.length == 2) {
            ApplicationTest.deleteUser(args[0], args[1]);
        } else if (args.length == 3) {
            ApplicationTest.deleteBookmark(args[0], args[1], args[2]);
        } else if (args.length == 4) {
            ApplicationTest.putUser(args[0], args[1], args[2], args[3]);
        } else if (args.length == 6) {
            ApplicationTest.putBookmark(args[0], args[1], args[2], args[3], args[4], Boolean.valueOf(args[5]));
        }
    }

    public static void putBookmark(String userName, String password, String uri, String shortDescription, String longDescription, boolean restrict) {
        Form form = new Form();
        form.add("bookmark[short_description]", shortDescription);
        form.add("bookmark[long_description]", longDescription);
        form.add("bookmark[restrict]", Boolean.toString(restrict));
        Request request = ApplicationTest.getAuthenticatedRequest(Method.PUT, ApplicationTest.getBookmarkUri(userName, uri), userName, password);
        request.setEntity(form.getWebRepresentation());
        Response resp = new Client(Protocol.HTTP).handle(request);
        System.out.println(resp.getStatus());
    }

    public static void putUser(String userName, String password, String fullName, String email) {
        Form form = new Form();
        form.add("user[password]", password);
        form.add("user[full_name]", fullName);
        form.add("user[email]", email);
        Response resp = new Client(Protocol.HTTP).put(ApplicationTest.getUserUri(userName), form.getWebRepresentation());
        System.out.println(resp.getStatus());
    }
}

