/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch7.jaxb;

import org.restlet.Client;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch7.jaxb.Customer;
import org.restlet.ext.jaxb.JaxbRepresentation;
import org.restlet.resource.Representation;

public class XmlTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Restlet jaxbRestlet = new Restlet(){

            public void handle(Request request, Response response) {
                Customer customer = new Customer();
                customer.setCity("city_value");
                customer.setPhone("phone_value");
                customer.setState("state_value");
                customer.setStreet("street_value");
                customer.setZip(10000);
                response.setEntity((Representation)new JaxbRepresentation(MediaType.TEXT_XML, (Object)customer));
            }
        };
        Server server = new Server(Protocol.HTTP, 8182, jaxbRestlet);
        try {
            server.start();
            Client client = new Client(Protocol.HTTP);
            Response response = client.get("http://localhost:8182/");
            if (response.isEntityAvailable()) {
                JaxbRepresentation representation = new JaxbRepresentation(response.getEntity(), Customer.class);
                Customer customer = (Customer)representation.getObject();
                System.out.println(customer.getCity());
                System.out.println(customer.getPhone());
                System.out.println(customer.getState());
                System.out.println(customer.getStreet());
                System.out.println(customer.getZip());
            } else {
                System.err.println("No entity");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

