/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.objects;

import java.util.ArrayList;
import java.util.List;
import org.restlet.example.book.restlet.ch8.data.DataFacade;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Feed;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.objects.ObjectsException;
import org.restlet.example.book.restlet.ch8.objects.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectsFacade {
    protected DataFacade dataFacade;

    public ObjectsFacade(DataFacade dataFacade) {
        this.dataFacade = dataFacade;
    }

    public Contact createContact(Mailbox mailbox, Contact contact) {
        contact = this.dataFacade.createContact(contact);
        mailbox.getContacts().add(contact);
        this.dataFacade.updateMailbox(mailbox);
        return contact;
    }

    public Feed createFeed(Mailbox mailbox, Feed feed) {
        feed = this.dataFacade.createFeed(feed);
        mailbox.getFeeds().add(feed);
        this.dataFacade.updateMailbox(mailbox);
        return feed;
    }

    public Mail createMail(Mailbox mailbox, Mail mail) {
        mail = this.dataFacade.createMail(mail);
        mailbox.getMails().add(mail);
        this.dataFacade.updateMailbox(mailbox);
        return mail;
    }

    public Mailbox createMailbox(Mailbox mailbox) throws ObjectsException {
        mailbox.setId(mailbox.getNickname());
        if (this.dataFacade.getMailboxById(mailbox.getId()) != null) {
            throw new ObjectsException("An other mailbox has the same name.");
        }
        this.dataFacade.createMailbox(mailbox);
        return mailbox;
    }

    public User createUser(User user) throws ObjectsException {
        user.setId(user.getLogin());
        if (this.dataFacade.getUserById(user.getId()) != null) {
            throw new ObjectsException("An other user has the same login.");
        }
        this.dataFacade.createUser(user);
        return user;
    }

    public void deleteContact(Mailbox mailbox, Contact contact) {
        boolean found = false;
        for (int i = 0; i < mailbox.getContacts().size() && !found; ++i) {
            Contact contact2 = mailbox.getContacts().get(i);
            if (!contact2.getId().equals(contact.getId())) continue;
            mailbox.getContacts().remove(i);
            found = true;
        }
        this.dataFacade.deleteContact(contact);
        this.dataFacade.updateMailbox(mailbox);
    }

    public void deleteFeed(Mailbox mailbox, Feed feed) {
        boolean found = false;
        for (int i = 0; i < mailbox.getFeeds().size() && !found; ++i) {
            Feed feed2 = mailbox.getFeeds().get(i);
            if (!feed2.getId().equals(feed.getId())) continue;
            mailbox.getFeeds().remove(i);
            found = true;
        }
        this.dataFacade.deleteFeed(feed);
        this.dataFacade.updateMailbox(mailbox);
    }

    public void deleteMail(Mailbox mailbox, Mail mail) {
        boolean found = false;
        for (int i = 0; i < mailbox.getMails().size() && !found; ++i) {
            Mail mail2 = mailbox.getMails().get(i);
            if (!mail2.getId().equals(mail.getId())) continue;
            mailbox.getMails().remove(i);
            found = true;
        }
        for (Contact contact : mail.getRecipients()) {
            if (contact.getId() != null) continue;
            this.dataFacade.deleteContact(contact);
        }
        if (mail.getSender().getId() == null) {
            this.dataFacade.deleteContact(mail.getSender());
        }
        this.dataFacade.deleteMail(mail);
        this.dataFacade.updateMailbox(mailbox);
    }

    public void deleteMailbox(Mailbox mailbox) {
        for (Feed feed : mailbox.getFeeds()) {
            this.dataFacade.deleteFeed(feed);
        }
        for (Mail mail : mailbox.getMails()) {
            this.dataFacade.deleteMail(mail);
        }
        for (Contact contact : mailbox.getContacts()) {
            this.dataFacade.deleteContact(contact);
        }
        this.dataFacade.deleteMailbox(mailbox);
    }

    public void deleteUser(User user) {
        List<Mailbox> mailboxes = this.getMailboxes(user);
        for (Mailbox mailbox : mailboxes) {
            this.deleteMailbox(mailbox);
        }
        this.dataFacade.deleteUser(user);
    }

    public Contact getContactById(String contactId) {
        return this.dataFacade.getContactById(contactId);
    }

    public Feed getFeedById(String feedId) {
        return this.dataFacade.getFeedById(feedId);
    }

    public Mailbox getMailboxById(String mailboxId) {
        return this.dataFacade.getMailboxById(mailboxId);
    }

    public List<Mailbox> getMailboxes() {
        return this.dataFacade.getMailboxes();
    }

    public List<Mailbox> getMailboxes(User user) {
        return this.dataFacade.getMailboxes(user);
    }

    public Mail getMailById(String mailId) {
        return this.dataFacade.getMailById(mailId);
    }

    public User getUserById(String userId) {
        return this.dataFacade.getUserById(userId);
    }

    public User getUserByLoginPwd(String login, char[] password) {
        return this.dataFacade.getUserByLoginPwd(login, password);
    }

    public List<User> getUsers() {
        return this.dataFacade.getUsers();
    }

    public void initAdmin() {
        this.dataFacade.initAdmin();
    }

    public Contact lookForContact(String mailboxAddress, Mailbox mailbox) {
        Contact contact = null;
        if (mailbox.getContacts() != null) {
            for (Contact item : mailbox.getContacts()) {
                if (!item.getMailAddress().equals(mailboxAddress)) continue;
                contact = item;
                break;
            }
        }
        return contact;
    }

    public void updateContact(Mailbox mailbox, Contact contact) {
        this.dataFacade.updateContact(contact);
    }

    public void updateFeed(Mailbox mailbox, Feed feed) {
        this.dataFacade.updateFeed(feed);
    }

    public void updateMail(Mailbox mailbox, Mail mail) {
        this.dataFacade.updateMail(mail);
    }

    public Mail updateMail(Mailbox mailbox, Mail mail, String status, String subject, String message, List<String> mailAddresses, List<String> tags) {
        mail.setSubject(subject);
        mail.setMessage(message);
        mail.setTags(tags);
        if ("draft".equalsIgnoreCase(mail.getStatus())) {
            ArrayList<Contact> mailRecipients = new ArrayList<Contact>();
            if (mailAddresses != null) {
                if (mail.getRecipients() != null) {
                    for (Contact recipient : mail.getRecipients()) {
                        if (mailAddresses.contains(recipient.getMailAddress())) continue;
                        this.dataFacade.deleteContact(recipient);
                    }
                }
                block1: for (String mailAddress : mailAddresses) {
                    Contact contact = this.lookForContact(mailAddress, mailbox);
                    if (contact != null) {
                        mailRecipients.add(contact);
                        continue;
                    }
                    for (Contact recipient : mail.getRecipients()) {
                        if (!recipient.getMailAddress().equals(mailAddress)) continue;
                        mailRecipients.add(recipient);
                        continue block1;
                    }
                }
                mail.setRecipients(mailRecipients);
            } else {
                if (mail.getRecipients() != null) {
                    for (Contact recipient : mail.getRecipients()) {
                        this.dataFacade.deleteContact(recipient);
                    }
                }
                mail.setRecipients(null);
            }
        }
        mail.setStatus(status);
        this.updateMail(mailbox, mail);
        return mail;
    }

    public void updateMailbox(Mailbox mailbox) {
        this.dataFacade.updateMailbox(mailbox);
    }

    public void updateUser(User user) {
        this.dataFacade.updateUser(user);
    }
}

