/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import freemarker.template.Configuration;
import java.util.Map;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.Application;
import org.restlet.example.book.restlet.ch8.objects.ObjectsFacade;
import org.restlet.example.book.restlet.ch8.objects.User;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseResource
extends Resource {
    private User currentUser = (User)this.getRequest().getAttributes().get("CURRENT_USER");

    public BaseResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.currentUser == null && this.getRequest().getChallengeResponse() != null) {
            this.currentUser = this.getObjectsFacade().getUserByLoginPwd(this.getRequest().getChallengeResponse().getIdentifier(), this.getRequest().getChallengeResponse().getSecret());
        }
    }

    protected Reference getChildReference(Reference parentRef, String childId) {
        if (parentRef.getIdentifier().endsWith("/")) {
            return new Reference(parentRef.getIdentifier() + childId);
        }
        return new Reference(parentRef.getIdentifier() + "/" + childId);
    }

    protected User getCurrentUser() {
        return this.currentUser;
    }

    private Configuration getFmcConfiguration() {
        Application application = (Application)this.getApplication();
        return application.getFmc();
    }

    protected Representation getHTMLTemplateRepresentation(String templateName, Map<String, Object> dataModel) {
        return new TemplateRepresentation(templateName, this.getFmcConfiguration(), dataModel, MediaType.TEXT_HTML);
    }

    protected ObjectsFacade getObjectsFacade() {
        Application application = (Application)this.getApplication();
        return application.getObjectsFacade();
    }
}

