/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.List;
import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;

public class ContactResource
extends BaseResource {
    private Contact contact;
    private Mailbox mailbox;
    private List<Mailbox> hostedMailboxes;

    public ContactResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            this.setModifiable(true);
            String mailboxId = Reference.decode((String)((String)request.getAttributes().get("mailboxId")));
            this.mailbox = this.getObjectsFacade().getMailboxById(mailboxId);
            if (this.mailbox != null) {
                String contactId = (String)request.getAttributes().get("contactId");
                this.contact = this.getObjectsFacade().getContactById(contactId);
                if (this.contact != null) {
                    this.hostedMailboxes = this.getObjectsFacade().getMailboxes();
                    this.getVariants().add(new Variant(MediaType.TEXT_HTML));
                }
            }
        } else {
            this.setModifiable(false);
        }
    }

    public boolean allowDelete() {
        return true;
    }

    public boolean allowPut() {
        return true;
    }

    public void removeRepresentations() throws ResourceException {
        this.getObjectsFacade().deleteContact(this.mailbox, this.contact);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef().getParentRef());
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("mailbox", this.mailbox);
        dataModel.put("contact", this.contact);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        dataModel.put("hostedMailboxes", this.hostedMailboxes);
        return this.getHTMLTemplateRepresentation("contact.html", dataModel);
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        this.contact.setMailAddress(form.getFirstValue("mailAddress"));
        this.contact.setName(form.getFirstValue("name"));
        this.getObjectsFacade().updateContact(this.mailbox, this.contact);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
    }
}

