/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Generator;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.atom.Text;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;

public class FeedResource
extends BaseResource {
    private org.restlet.example.book.restlet.ch8.objects.Feed feed;
    private List<Mail> mails;
    private Mailbox mailbox;

    public FeedResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            this.setModifiable(true);
            String mailboxId = Reference.decode((String)((String)request.getAttributes().get("mailboxId")));
            this.mailbox = this.getObjectsFacade().getMailboxById(mailboxId);
            if (this.mailbox != null) {
                String feedId = (String)request.getAttributes().get("feedId");
                this.feed = this.getObjectsFacade().getFeedById(feedId);
                if (this.feed != null) {
                    this.mails = new ArrayList<Mail>();
                    if (this.feed.getTags() != null) {
                        for (Mail mail : this.mailbox.getMails()) {
                            if (mail.getTags() == null || !mail.getTags().containsAll(this.feed.getTags())) continue;
                            this.mails.add(mail);
                        }
                    }
                    this.getVariants().add(new Variant(MediaType.APPLICATION_ATOM_XML));
                    this.getVariants().add(new Variant(MediaType.TEXT_HTML));
                }
            }
        } else {
            this.setModifiable(false);
        }
    }

    public boolean allowDelete() {
        return true;
    }

    public boolean allowPut() {
        return true;
    }

    public void removeRepresentations() throws ResourceException {
        this.getObjectsFacade().deleteFeed(this.mailbox, this.feed);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef().getParentRef());
    }

    public Representation represent(Variant variant) throws ResourceException {
        Representation representation = null;
        MediaType mediaType = variant.getMediaType();
        if (MediaType.TEXT_HTML.equals((Object)mediaType)) {
            TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
            dataModel.put("currentUser", this.getCurrentUser());
            dataModel.put("mailbox", this.mailbox);
            dataModel.put("feed", this.feed);
            dataModel.put("mails", this.mails);
            dataModel.put("resourceRef", this.getRequest().getResourceRef());
            dataModel.put("rootRef", this.getRequest().getRootRef());
            StringBuilder builder = new StringBuilder();
            builder.append("<link ");
            builder.append("rel=\"alternate\" ");
            builder.append("type=\"application/atom+xml\" ");
            builder.append("href=\"");
            builder.append(this.getRequest().getResourceRef().toString(false, false) + "?media=xml");
            builder.append("\" ");
            builder.append("title=\"feed\"");
            builder.append("/>");
            dataModel.put("feedHeaderContent", builder.toString());
            representation = this.getHTMLTemplateRepresentation("feed.html", dataModel);
        } else if (MediaType.APPLICATION_ATOM_XML.equals((Object)mediaType)) {
            Feed atomFeed = new Feed();
            Person currentAuthor = new Person();
            currentAuthor.setName(this.mailbox.getSenderName());
            currentAuthor.setUri(new Reference(this.getRequest().getRootRef().toString() + "/mailboxes/" + Reference.encode((String)this.mailbox.getId(), (CharacterSet)CharacterSet.US_ASCII)));
            atomFeed.getAuthors().add(currentAuthor);
            StringBuilder titleBuilder = new StringBuilder("Feed");
            for (String tag : this.feed.getTags()) {
                Category category = new Category();
                category.setLabel(tag);
                category.setTerm(tag);
                atomFeed.getCategories().add(category);
                titleBuilder.append(" ").append(tag);
            }
            Generator generator = new Generator();
            generator.setName("Atom extension for Restlet.");
            generator.setUri(new Reference("http://restlet.org"));
            generator.setVersion("1.1.10");
            atomFeed.setGenerator(generator);
            atomFeed.setId(this.getRequest().getRootRef().toString() + "/mailboxes/" + this.mailbox.getId() + "/feeds/" + this.feed.getId());
            Link link = new Link();
            link.setHref(new Reference(this.getRequest().getRootRef().toString() + "/mailboxes/" + this.mailbox.getId() + "/feeds/" + this.feed.getId()));
            link.setRel(Relation.ALTERNATE);
            link.setTitle(titleBuilder.toString());
            link.setType(MediaType.TEXT_HTML);
            atomFeed.getLinks().add(link);
            link = new Link();
            link.setHref(this.getRequest().getResourceRef());
            link.setRel(Relation.SELF);
            link.setTitle(titleBuilder.toString());
            link.setType(mediaType);
            atomFeed.getLinks().add(link);
            atomFeed.setTitle(new Text(MediaType.TEXT_PLAIN, titleBuilder.toString()));
            atomFeed.setUpdated(new Date());
            for (Mail mail : this.mails) {
                Entry entry = new Entry();
                Person author = new Person();
                author.setName(mail.getSender().getName());
                author.setUri(new Reference(mail.getSender().getMailAddress()));
                entry.getAuthors().add(author);
                StringBuilder entryTitleBuilder = new StringBuilder("Feed");
                for (String tag : mail.getTags()) {
                    Category category = new Category();
                    category.setLabel(tag);
                    category.setTerm(tag);
                    entry.getCategories().add(category);
                    entryTitleBuilder.append(" ").append(tag);
                }
                Content content = new Content();
                content.setInlineContent((Representation)new StringRepresentation((CharSequence)mail.getMessage(), MediaType.TEXT_PLAIN));
                entry.setContent(content);
                for (Contact recipient : mail.getRecipients()) {
                    Person contributor = new Person();
                    contributor.setName(recipient.getName());
                    contributor.setUri(new Reference(recipient.getMailAddress()));
                    entry.getContributors().add(contributor);
                }
                entry.setId(this.getRequest().getRootRef().toString() + "/mailboxes/" + this.mailbox.getId() + "/mails" + mail.getId());
                Link entryLink = new Link();
                entryLink.setHref(new Reference(this.getRequest().getRootRef().toString() + "/mailboxes/" + this.mailbox.getId() + "/mails" + mail.getId()));
                entryLink.setRel(Relation.ALTERNATE);
                entryLink.setTitle(entryTitleBuilder.toString());
                entryLink.setType(MediaType.TEXT_HTML);
                entry.getLinks().add(entryLink);
                entryLink = new Link();
                entryLink.setHref(new Reference(this.getRequest().getRootRef().toString() + "/mailboxes/" + this.mailbox.getId() + "/mails" + mail.getId()));
                entryLink.setRel(Relation.SELF);
                entryLink.setTitle(entryTitleBuilder.toString());
                entryLink.setType(mediaType);
                entry.getLinks().add(entryLink);
                entry.setPublished(mail.getSendingDate());
                if (mail.getMessage().length() > 100) {
                    entry.setSummary(mail.getMessage().substring(0, 97) + "...");
                } else {
                    entry.setSummary(mail.getMessage());
                }
                entry.setTitle(new Text(MediaType.TEXT_PLAIN, mail.getSubject()));
                entry.setUpdated(mail.getSendingDate());
                atomFeed.getEntries().add(entry);
            }
            representation = atomFeed;
            representation.setMediaType(mediaType);
        }
        return representation;
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        this.feed.setNickname(form.getFirstValue("nickname"));
        if (form.getFirstValue("tags") != null) {
            this.feed.setTags(new ArrayList<String>(Arrays.asList(form.getFirstValue("tags").split(" "))));
        } else {
            this.feed.setTags(null);
        }
        this.getObjectsFacade().updateFeed(this.mailbox, this.feed);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
    }
}

