/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;

public class MailsResource
extends BaseResource {
    private Mailbox mailbox;
    private List<Mail> mails;

    public MailsResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            this.setModifiable(true);
            String mailboxId = Reference.decode((String)((String)request.getAttributes().get("mailboxId")));
            this.mailbox = this.getObjectsFacade().getMailboxById(mailboxId);
            if (this.mailbox != null) {
                this.mails = this.mailbox.getMails();
                this.getVariants().add(new Variant(MediaType.TEXT_HTML));
            }
        } else {
            this.setModifiable(false);
        }
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        Mail mail = new Mail();
        mail.setStatus("draft");
        Contact sender = new Contact();
        sender.setName(this.getCurrentUser().getFirstName() + " " + this.getCurrentUser().getLastName());
        sender.setMailAddress(this.getRequest().getRootRef().getIdentifier() + "/mailboxes/" + this.mailbox.getId());
        mail.setSender(sender);
        mail.setSubject(form.getFirstValue("subject"));
        mail.setMessage(form.getFirstValue("message"));
        if (form.getFirstValue("recipients") != null) {
            ArrayList<Contact> recipients = new ArrayList<Contact>();
            for (Parameter parameter : form.subList("recipients")) {
                for (Contact contact : this.mailbox.getContacts()) {
                    if (!contact.getId().equals(parameter.getValue())) continue;
                    recipients.add(contact);
                }
            }
            mail.setRecipients(recipients);
        } else {
            mail.setRecipients(null);
        }
        if (form.getFirstValue("tags") != null) {
            mail.setTags(new ArrayList<String>(Arrays.asList(form.getFirstValue("tags").split(" "))));
        } else {
            mail.setTags(null);
        }
        mail = this.getObjectsFacade().createMail(this.mailbox, mail);
        this.getResponse().redirectSeeOther(this.getChildReference(this.getRequest().getResourceRef(), mail.getId()));
    }

    public boolean allowPost() {
        return true;
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("mailbox", this.mailbox);
        dataModel.put("mails", this.mails);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getHTMLTemplateRepresentation("mails.html", dataModel);
    }
}

