/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.restlet.ch8.objects.ObjectsException;
import org.restlet.example.book.restlet.ch8.objects.User;
import org.restlet.example.book.restlet.ch8.resources.BaseResource;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;

public class UsersResource
extends BaseResource {
    private List<User> users;

    public UsersResource(Context context, Request request, Response response) {
        super(context, request, response);
        if (this.getCurrentUser() != null) {
            if (this.getCurrentUser().isAdministrator()) {
                this.setModifiable(true);
                this.users = this.getObjectsFacade().getUsers();
            } else {
                this.users = new ArrayList<User>();
                this.users.add(this.getCurrentUser());
            }
        } else {
            this.setModifiable(false);
        }
        this.getVariants().add(new Variant(MediaType.TEXT_HTML));
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        User user = new User();
        user.setFirstName(form.getFirstValue("firstName"));
        user.setLastName(form.getFirstValue("lastName"));
        user.setLogin(form.getFirstValue("login"));
        user.setPassword(form.getFirstValue("password"));
        user.setAdministrator(form.getFirstValue("administrator") != null);
        try {
            user = this.getObjectsFacade().createUser(user);
            this.getResponse().redirectSeeOther(this.getChildReference(this.getRequest().getResourceRef(), user.getId()));
        }
        catch (ObjectsException e) {
            TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
            dataModel.put("currentUser", this.getCurrentUser());
            dataModel.put("users", this.users);
            dataModel.put("resourceRef", this.getRequest().getResourceRef());
            dataModel.put("rootRef", this.getRequest().getRootRef());
            dataModel.put("firstName", form.getFirstValue("firstName"));
            dataModel.put("lastName", form.getFirstValue("lastName"));
            dataModel.put("login", form.getFirstValue("login"));
            dataModel.put("password", form.getFirstValue("password"));
            dataModel.put("errorMessage", e.getMessage());
            this.getResponse().setEntity(this.getHTMLTemplateRepresentation("users.html", dataModel));
        }
    }

    public Representation represent(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("currentUser", this.getCurrentUser());
        dataModel.put("users", this.users);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getHTMLTemplateRepresentation("users.html", dataModel);
    }
}

