/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Feed;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.MailRoot;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.objects.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainObjects {
    private final MailRoot mailRoot;
    private int contactSequence = 1;
    private int feedSequence = 1;
    private int mailSequence = 1;
    private int mailboxSequence = 1;
    private final String[] mailStatuses = new String[]{"draft", "sending", "sent", "receiving", "received"};
    private final List<String> mailTags = Arrays.asList("tag1", "tag2", "tag3");

    public DomainObjects() {
        this.mailRoot = new MailRoot();
        User user = new User();
        user.setId("agathe_zeblues");
        user.setFirstName("Agathe Zeblues");
        user.setAdministrator(false);
        this.mailRoot.getUsers().add(user);
        User admin = new User();
        admin.setId("admin");
        admin.setFirstName("admin");
        admin.setAdministrator(true);
        this.mailRoot.getUsers().add(admin);
        this.mailRoot.getMailboxes().add(this.createMailbox(user));
        this.mailRoot.getMailboxes().add(this.createMailbox(user));
        this.mailRoot.getMailboxes().add(this.createMailbox(admin));
    }

    private Contact createContact() {
        Contact contact = new Contact();
        contact.setId(Integer.toString(this.contactSequence++));
        contact.setName("contact-" + contact.getId());
        contact.setMailAddress("http://rmep.com/contacts/" + contact.getName());
        return contact;
    }

    private Feed createFeed(List<String> tags) {
        Feed feed = new Feed();
        feed.setId(Integer.toString(this.feedSequence++));
        feed.setTags(tags);
        return feed;
    }

    private Mail createMail(User sender, List<Contact> recipients, List<Feed> feeds) {
        Mail mail = new Mail();
        mail.setId(Integer.toString(this.mailSequence++));
        mail.setRecipients(new ArrayList<Contact>(recipients.subList(0, Integer.parseInt(mail.getId()) % recipients.size() + 1)));
        mail.setMessage("Cheers -" + sender.getFirstName());
        mail.setSendingDate(new Date());
        mail.setSubject("Hello!");
        mail.setStatus(this.mailStatuses[Integer.parseInt(mail.getId()) % this.mailStatuses.length]);
        mail.setTags(new ArrayList<String>(this.mailTags.subList(0, Integer.parseInt(mail.getId()) % (this.mailTags.size() + 1))));
        if (!mail.getTags().isEmpty()) {
            for (Feed feed : feeds) {
                if (!mail.getTags().containsAll(feed.getTags())) continue;
                feed.getMails().add(mail);
            }
        }
        return mail;
    }

    private Mailbox createMailbox(User owner) {
        int i;
        Mailbox mailbox = new Mailbox();
        mailbox.setId(Integer.toString(this.mailboxSequence++));
        mailbox.setOwner(owner);
        int index = Integer.parseInt(mailbox.getId()) % this.mailTags.size();
        mailbox.getFeeds().add(this.createFeed(Arrays.asList(this.mailTags.get(index))));
        for (i = 0; i < this.mailboxSequence; ++i) {
            mailbox.getContacts().add(this.createContact());
        }
        for (i = 0; i < this.mailboxSequence; ++i) {
            mailbox.getMails().add(this.createMail(owner, mailbox.getContacts(), mailbox.getFeeds()));
        }
        return mailbox;
    }

    public MailRoot getMailRoot() {
        return this.mailRoot;
    }
}

