/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch8.tests;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.query.Predicate;
import com.db4o.ta.TransparentPersistenceSupport;
import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.restlet.example.book.restlet.ch8.objects.Contact;
import org.restlet.example.book.restlet.ch8.objects.Mail;
import org.restlet.example.book.restlet.ch8.objects.MailRoot;
import org.restlet.example.book.restlet.ch8.objects.Mailbox;
import org.restlet.example.book.restlet.ch8.objects.User;
import org.restlet.example.book.restlet.ch8.tests.DomainObjects;

public class PersistenceTestCase
extends TestCase {
    private DomainObjects domainObjects;
    private MailRoot mailRoot;
    ObjectContainer objectContainer;
    File db4oFile = new File(System.getProperty("java.io.tmpdir"), "testdb4o.dbo");

    protected void setUp() throws Exception {
        super.setUp();
        this.db4oFile.delete();
        Configuration configuration = Db4o.newConfiguration();
        configuration.activationDepth(10);
        configuration.add((ConfigurationItem)new TransparentPersistenceSupport());
        this.objectContainer = Db4o.openFile((Configuration)configuration, (String)this.db4oFile.getAbsolutePath());
        this.domainObjects = new DomainObjects();
        this.mailRoot = this.domainObjects.getMailRoot();
        this.objectContainer.store((Object)this.mailRoot);
        this.mailRoot = null;
        ObjectSet list = this.objectContainer.queryByExample((Object)new MailRoot());
        if (list.isEmpty()) {
            throw new Exception("The database has not been properly mounted.");
        }
        this.mailRoot = (MailRoot)list.get(0);
    }

    protected void tearDown() throws Exception {
        this.objectContainer.close();
        super.tearDown();
    }

    public void testDB1() {
        Mailbox mailbox = this.mailRoot.getMailboxes().get(2);
        User proto = new User();
        proto.setAdministrator(true);
        ObjectSet result = this.objectContainer.queryByExample((Object)proto);
        PersistenceTestCase.assertEquals((int)result.size(), (int)1);
        mailbox.getOwner().setAdministrator(false);
        this.objectContainer.store((Object)mailbox.getOwner());
        this.objectContainer.commit();
        result = this.objectContainer.queryByExample((Object)proto);
        PersistenceTestCase.assertEquals((int)result.size(), (int)0);
    }

    public void testDB2() {
        Contact contactProto = new Contact();
        Predicate<Mail> mailByContactNamePredicate = new Predicate<Mail>(){
            static final long serialVersionUID = 1L;

            public boolean match(Mail mail) {
                boolean found = false;
                for (Contact contact : mail.getRecipients()) {
                    if (!"contact-5".equals(contact.getName())) continue;
                    found = true;
                    break;
                }
                return found;
            }
        };
        Predicate<Mailbox> mailboxByContactNamePredicate = new Predicate<Mailbox>(){
            static final long serialVersionUID = 1L;

            public boolean match(Mailbox mailbox) {
                boolean found = false;
                for (Contact contact : mailbox.getContacts()) {
                    if (!"contact-5".equals(contact.getName())) continue;
                    found = true;
                    break;
                }
                return found;
            }
        };
        contactProto.setName("contact-4");
        ObjectSet contactList = this.objectContainer.queryByExample((Object)contactProto);
        PersistenceTestCase.assertEquals((int)contactList.size(), (int)1);
        ObjectSet mailList = this.objectContainer.query((Predicate)mailByContactNamePredicate);
        PersistenceTestCase.assertEquals((int)mailList.size(), (int)1);
        Contact contact = (Contact)contactList.get(0);
        contact.setName("contact-5");
        this.objectContainer.store((Object)contact);
        this.objectContainer.commit();
        mailList = this.objectContainer.query((Predicate)mailByContactNamePredicate);
        PersistenceTestCase.assertEquals((int)mailList.size(), (int)2);
        ObjectSet mailboxList = this.objectContainer.query((Predicate)mailboxByContactNamePredicate);
        PersistenceTestCase.assertEquals((int)mailboxList.size(), (int)1);
        contactProto.setName("contact-5");
        contactList = this.objectContainer.queryByExample((Object)contactProto);
        for (Contact contact2 : contactList) {
            Contact contact3;
            int i;
            for (Mailbox mailbox : mailboxList) {
                boolean found = false;
                for (i = 0; i < mailbox.getContacts().size() && !found; ++i) {
                    contact3 = mailbox.getContacts().get(i);
                    if (!contact2.getId().equals(contact3.getId())) continue;
                    mailbox.getContacts().remove(i);
                    found = true;
                }
                this.objectContainer.store((Object)mailbox);
            }
            for (Mail mail : mailList) {
                ArrayList<Contact> list = new ArrayList<Contact>();
                for (i = 0; i < mail.getRecipients().size(); ++i) {
                    contact3 = mail.getRecipients().get(i);
                    if (contact2.getId().equals(contact3.getId())) continue;
                    list.add(contact3);
                }
                mail.setRecipients(list);
                this.objectContainer.store((Object)mail);
            }
            this.objectContainer.delete((Object)contact2);
        }
        this.objectContainer.commit();
        contactList = this.objectContainer.queryByExample((Object)contactProto);
        PersistenceTestCase.assertTrue((boolean)contactList.isEmpty());
        mailboxList = this.objectContainer.query((Predicate)mailboxByContactNamePredicate);
        PersistenceTestCase.assertTrue((boolean)mailboxList.isEmpty());
        mailList = this.objectContainer.query((Predicate)mailByContactNamePredicate);
        PersistenceTestCase.assertTrue((boolean)mailList.isEmpty());
    }

    public void testMailbox1() {
        Mailbox mailbox = this.mailRoot.getMailboxes().get(0);
        PersistenceTestCase.assertEquals((int)mailbox.getContacts().size(), (int)2);
        PersistenceTestCase.assertEquals((String)mailbox.getContacts().get(1).getName(), (String)"contact-2");
        PersistenceTestCase.assertEquals((int)mailbox.getMails().size(), (int)2);
        PersistenceTestCase.assertEquals((String)mailbox.getMails().get(0).getTags().get(0), (String)"tag1");
        PersistenceTestCase.assertEquals((int)mailbox.getMails().get(1).getTags().size(), (int)2);
        PersistenceTestCase.assertEquals((String)mailbox.getFeeds().get(0).getTags().get(0), (String)"tag2");
        PersistenceTestCase.assertEquals((String)mailbox.getMails().get(1).getTags().get(1), (String)"tag2");
        PersistenceTestCase.assertFalse((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(0)));
        PersistenceTestCase.assertTrue((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(1)));
        PersistenceTestCase.assertEquals((Object)mailbox.getMails().get(0).getRecipients().get(0), (Object)mailbox.getContacts().get(0));
        PersistenceTestCase.assertEquals((Object)mailbox.getMails().get(0).getRecipients().get(1), (Object)mailbox.getContacts().get(1));
    }

    public void testMailbox2() {
        Mailbox mailbox = this.mailRoot.getMailboxes().get(1);
        PersistenceTestCase.assertEquals((int)mailbox.getContacts().size(), (int)3);
        PersistenceTestCase.assertEquals((String)mailbox.getContacts().get(1).getName(), (String)"contact-4");
        PersistenceTestCase.assertEquals((int)mailbox.getMails().size(), (int)3);
        PersistenceTestCase.assertEquals((String)mailbox.getMails().get(0).getTags().get(0), (String)"tag1");
        PersistenceTestCase.assertTrue((boolean)mailbox.getMails().get(1).getTags().isEmpty());
        PersistenceTestCase.assertEquals((String)mailbox.getFeeds().get(0).getTags().get(0), (String)"tag3");
        PersistenceTestCase.assertEquals((int)mailbox.getFeeds().get(0).getMails().size(), (int)1);
        PersistenceTestCase.assertTrue((boolean)mailbox.getMails().get(1).getTags().isEmpty());
        PersistenceTestCase.assertTrue((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(0)));
        PersistenceTestCase.assertFalse((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(1)));
        PersistenceTestCase.assertEquals((int)mailbox.getMails().get(0).getRecipients().size(), (int)1);
        PersistenceTestCase.assertEquals((int)mailbox.getMails().get(1).getRecipients().size(), (int)2);
        PersistenceTestCase.assertEquals((Object)mailbox.getMails().get(0).getRecipients().get(0), (Object)mailbox.getContacts().get(0));
        PersistenceTestCase.assertEquals((Object)mailbox.getMails().get(1).getRecipients().get(1), (Object)mailbox.getContacts().get(1));
    }

    public void testMailbox3() {
        Mailbox mailbox = this.mailRoot.getMailboxes().get(2);
        PersistenceTestCase.assertEquals((int)mailbox.getContacts().size(), (int)4);
        PersistenceTestCase.assertEquals((String)mailbox.getContacts().get(1).getName(), (String)"contact-7");
        PersistenceTestCase.assertEquals((int)mailbox.getMails().size(), (int)4);
        PersistenceTestCase.assertEquals((String)mailbox.getMails().get(0).getTags().get(0), (String)"tag1");
        PersistenceTestCase.assertEquals((String)mailbox.getMails().get(0).getTags().get(1), (String)"tag2");
        PersistenceTestCase.assertEquals((String)mailbox.getMails().get(1).getTags().get(2), (String)"tag3");
        PersistenceTestCase.assertTrue((boolean)mailbox.getMails().get(2).getTags().isEmpty());
        PersistenceTestCase.assertEquals((String)mailbox.getFeeds().get(0).getTags().get(0), (String)"tag1");
        PersistenceTestCase.assertEquals((int)mailbox.getFeeds().get(0).getMails().size(), (int)3);
        PersistenceTestCase.assertTrue((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(0)));
        PersistenceTestCase.assertTrue((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(1)));
        PersistenceTestCase.assertFalse((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(2)));
        PersistenceTestCase.assertTrue((boolean)mailbox.getFeeds().get(0).getMails().contains(mailbox.getMails().get(3)));
        PersistenceTestCase.assertEquals((int)mailbox.getMails().get(1).getRecipients().size(), (int)4);
        PersistenceTestCase.assertEquals((Object)mailbox.getMails().get(1).getRecipients().get(3), (Object)mailbox.getContacts().get(3));
    }

    public void testMailboxes() {
        PersistenceTestCase.assertEquals((int)this.mailRoot.getMailboxes().size(), (int)3);
        PersistenceTestCase.assertEquals((Object)this.mailRoot.getMailboxes().get(0).getOwner(), (Object)this.mailRoot.getUsers().get(0));
        PersistenceTestCase.assertTrue((boolean)this.mailRoot.getMailboxes().get(2).getOwner().isAdministrator());
    }
}

