/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.wadl;

import java.io.IOException;
import java.io.OutputStream;
import org.restlet.Client;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.ext.wadl.Item;
import org.restlet.resource.Representation;

public class FirstResourceClient {
    public static void main(String[] args) throws IOException {
        Reference appUri = new Reference("http://localhost:8182/firstResource/");
        Reference itemsUri = new Reference(appUri, "items");
        Client client = new Client(Protocol.HTTP);
        client.options(appUri).getEntity().write((OutputStream)System.out);
        client.options(itemsUri).getEntity().write((OutputStream)System.out);
        Item item = new Item("item1", "this is an item.");
        Reference itemUri = FirstResourceClient.createItem(item, client, itemsUri);
        client.options(itemUri).getEntity().write((OutputStream)System.out);
        Request request = new Request(Method.OPTIONS, itemUri);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML));
        client.handle(request).getEntity().write((OutputStream)System.out);
    }

    public static Reference createItem(Item item, Client client, Reference itemsUri) {
        Form form = new Form();
        form.add("name", item.getName());
        form.add("description", item.getDescription());
        Representation rep = form.getWebRepresentation();
        Response response = client.post(itemsUri, rep);
        if (response.getStatus().isSuccess()) {
            return response.getEntity().getIdentifier();
        }
        return null;
    }
}

