/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.firstResource;

import java.io.IOException;
import java.io.OutputStream;
import org.restlet.Client;
import org.restlet.data.Form;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Response;
import org.restlet.example.firstResource.Item;
import org.restlet.resource.Representation;

public class FirstResourceClientMain {
    public static void main(String[] args) throws IOException {
        Item item = new Item("item1", "this is an item.");
        Client client = new Client(Protocol.HTTP);
        Reference itemsUri = new Reference("http://localhost:8182/firstResource/items");
        Reference itemUri = FirstResourceClientMain.createItem(item, client, itemsUri);
        if (itemUri != null) {
            FirstResourceClientMain.get(client, itemUri);
        }
        FirstResourceClientMain.get(client, itemsUri);
        item.setDescription("This is an other description");
        FirstResourceClientMain.updateItem(item, client, itemUri);
        FirstResourceClientMain.get(client, itemsUri);
        FirstResourceClientMain.deleteItem(client, itemUri);
        FirstResourceClientMain.get(client, itemsUri);
    }

    public static Reference createItem(Item item, Client client, Reference itemsUri) {
        Form form = new Form();
        form.add("name", item.getName());
        form.add("description", item.getDescription());
        Representation rep = form.getWebRepresentation();
        Response response = client.post(itemsUri, rep);
        if (response.getStatus().isSuccess()) {
            return response.getEntity().getIdentifier();
        }
        return null;
    }

    public static void get(Client client, Reference reference) throws IOException {
        Response response = client.get(reference);
        if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
            response.getEntity().write((OutputStream)System.out);
        }
    }

    public static boolean updateItem(Item item, Client client, Reference itemUri) {
        Form form = new Form();
        form.add("name", item.getName());
        form.add("description", item.getDescription());
        Representation rep = form.getWebRepresentation();
        Response response = client.put(itemUri, rep);
        return response.getStatus().isSuccess();
    }

    public static boolean deleteItem(Client client, Reference itemUri) {
        Response response = client.delete(itemUri);
        return response.getStatus().isSuccess();
    }
}

