/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.spring.book.rest.ch7;

import java.util.Date;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.example.book.rest.ch7.Bookmark;
import org.restlet.example.spring.book.rest.ch7.UserResource;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;

public class BookmarkResource
extends UserResource {
    private Bookmark bookmark;
    private String uri;

    public BookmarkResource() {
    }

    public BookmarkResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.init(context, request, response);
    }

    public void init(Context context, Request request, Response response) {
        super.init(context, request, response);
        this.setModifiable(true);
        if (this.getUser() != null) {
            this.uri = (String)this.getRequest().getAttributes().get("URI");
            this.bookmark = this.getUser().getBookmark(this.uri);
            if (this.bookmark != null) {
                if (this.checkAuthorization() != 1 && this.bookmark.isRestrict()) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                }
            } else {
                this.getVariants().clear();
            }
        } else {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    public void removeRepresentations() {
        if (this.bookmark != null && this.checkAuthorization() == 1) {
            this.getUser().getBookmarks().remove(this.bookmark);
            this.getContainer().delete((Object)this.bookmark);
            this.getContainer().store((Object)this.getUser());
            this.getContainer().commit();
            this.getResponse().setStatus(Status.SUCCESS_OK);
        } else {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    public Representation represent(Variant variant) {
        StringRepresentation result = null;
        if (variant.getMediaType().equals((Object)MediaType.TEXT_PLAIN)) {
            StringBuilder sb = new StringBuilder();
            sb.append("----------------\n");
            sb.append("Bookmark details\n");
            sb.append("----------------\n\n");
            sb.append("User:     ").append(this.bookmark.getUser().getName()).append('\n');
            sb.append("URI:      ").append(this.bookmark.getUri()).append('\n');
            sb.append("Short:    ").append(this.bookmark.getShortDescription()).append('\n');
            sb.append("Long:     ").append(this.bookmark.getLongDescription()).append('\n');
            sb.append("Date:     ").append(this.bookmark.getDateTime()).append('\n');
            sb.append("Restrict: ").append(Boolean.toString(this.bookmark.isRestrict())).append('\n');
            result = new StringRepresentation((CharSequence)sb);
        }
        return result;
    }

    public void storeRepresentation(Representation entity) {
        if (this.checkAuthorization() == 1) {
            if (entity.getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM, true)) {
                Form form = new Form(entity);
                if (this.bookmark == null) {
                    this.bookmark = new Bookmark(this.getUser(), this.uri);
                    this.getUser().getBookmarks().add(this.bookmark);
                    this.getResponse().setStatus(Status.SUCCESS_CREATED);
                } else {
                    this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
                }
                this.bookmark.setShortDescription(form.getFirstValue("bookmark[short_description]"));
                this.bookmark.setLongDescription(form.getFirstValue("bookmark[long_description]"));
                this.bookmark.setDateTime(new Date());
                this.bookmark.setRestrict(new Boolean(form.getFirstValue("bookmark[restrict]")));
                this.getContainer().store((Object)this.bookmark);
                this.getContainer().store((Object)this.getUser());
                this.getContainer().commit();
            }
        } else {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }
}

