/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.spring.book.rest.ch7;

import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.example.book.rest.ch7.Bookmark;
import org.restlet.example.spring.book.rest.ch7.UserResource;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;

public class BookmarksResource
extends UserResource {
    public BookmarksResource() {
    }

    public BookmarksResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.init(context, request, response);
    }

    public void handleGet() {
        Reference ref = this.getRequest().getResourceRef();
        if (!ref.getPath().endsWith("/")) {
            ref.setPath(ref.getPath() + "/");
            this.getResponse().redirectPermanent(ref);
        } else {
            super.handleGet();
        }
    }

    public void init(Context context, Request request, Response response) {
        super.init(context, request, response);
        this.getVariants().clear();
        if (this.getUser() != null) {
            this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        }
    }

    public Representation represent(Variant variant) {
        Representation result = null;
        if (variant.getMediaType().equals((Object)MediaType.TEXT_HTML)) {
            int code = this.checkAuthorization();
            ReferenceList rl = new ReferenceList();
            for (Bookmark bookmark : this.getUser().getBookmarks()) {
                if (bookmark.isRestrict() && code != 1) continue;
                rl.add(bookmark.getUri());
            }
            result = rl.getWebRepresentation();
        }
        return result;
    }
}

