/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.spring.book.rest.ch7;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import org.restlet.Context;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.example.book.rest.ch7.Bookmark;
import org.restlet.example.book.rest.ch7.User;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;

public class UserResource
extends Resource {
    private ObjectContainer container;
    private String login;
    private String password;
    private User user;
    private String userName;

    public UserResource() {
    }

    public UserResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.init(context, request, response);
    }

    public void challenge() {
        this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
        this.getResponse().setChallengeRequest(new ChallengeRequest(ChallengeScheme.HTTP_BASIC, "Restlet"));
    }

    public int checkAuthorization() {
        int result = 0;
        if (this.user != null && this.login != null && this.password != null) {
            result = this.userName.equals(this.login) && this.password.equals(this.user.getPassword()) ? 1 : -1;
        }
        return result;
    }

    public User findUser() {
        User result = null;
        if (this.userName != null) {
            Predicate<User> predicate = new Predicate<User>(){
                private static final long serialVersionUID = 1L;

                public boolean match(User candidate) {
                    return UserResource.this.userName.equals(candidate.getName());
                }
            };
            ObjectSet users = this.getContainer().query((Predicate)predicate);
            if (users != null && users.size() > 0) {
                result = (User)users.get(0);
            }
        }
        return result;
    }

    public ObjectContainer getContainer() {
        return this.container;
    }

    public User getUser() {
        return this.user;
    }

    public void init(Context context, Request request, Response response) {
        super.init(context, request, response);
        this.userName = (String)this.getRequest().getAttributes().get("username");
        ChallengeResponse cr = this.getRequest().getChallengeResponse();
        this.login = cr != null ? cr.getIdentifier() : null;
        this.password = cr != null ? new String(cr.getSecret()) : null;
        this.user = this.findUser();
        if (this.user != null) {
            this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        }
        this.setModifiable(true);
    }

    public void removeRepresentations() {
        switch (this.checkAuthorization()) {
            case 1: {
                for (Bookmark bookmark : this.user.getBookmarks()) {
                    this.getContainer().delete((Object)bookmark);
                }
                this.getContainer().delete((Object)this.user);
                this.getContainer().commit();
                this.getResponse().setStatus(Status.SUCCESS_OK);
                break;
            }
            case 0: {
                this.challenge();
                break;
            }
            case -1: {
                this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            }
        }
    }

    public Representation represent(Variant variant) {
        StringRepresentation result = null;
        if (variant != null && variant.getMediaType().equals((Object)MediaType.TEXT_PLAIN)) {
            StringBuilder sb = new StringBuilder();
            sb.append("------------\n");
            sb.append("User details\n");
            sb.append("------------\n\n");
            sb.append("Name:  ").append(this.user.getFullName()).append('\n');
            sb.append("Email: ").append(this.user.getEmail()).append('\n');
            result = new StringRepresentation((CharSequence)sb);
        }
        return result;
    }

    public void setContainer(ObjectContainer container) {
        this.container = container;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void storeRepresentation(Representation entity) {
        if (entity.getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM, true)) {
            boolean canSet = true;
            if (this.getUser() == null) {
                this.setUser(new User());
                this.getUser().setName(this.userName);
                this.getResponse().setStatus(Status.SUCCESS_CREATED);
            } else {
                switch (this.checkAuthorization()) {
                    case 1: {
                        this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
                        break;
                    }
                    case 0: {
                        this.challenge();
                        canSet = false;
                        break;
                    }
                    case -1: {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                        canSet = false;
                    }
                }
            }
            if (canSet) {
                Form form = new Form(entity);
                this.getUser().setEmail(form.getFirstValue("user[email]"));
                this.getUser().setFullName(form.getFirstValue("user[full_name]"));
                this.getUser().setPassword(form.getFirstValue("user[password]"));
                this.getContainer().store((Object)this.getUser());
                this.getContainer().commit();
            }
        }
    }
}

