/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import org.restlet.data.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityUtil {
    private static final String ORG_RESTLET_HTTPS_CLIENT_CERTS = "org.restlet.https.clientCertificates";

    public static Principal getSslClientCertPrincipal(Request request) {
        List<X509Certificate> sslClientCerts = SecurityUtil.getSslClientCerts(request);
        if (sslClientCerts != null) {
            for (X509Certificate cert : sslClientCerts) {
                Principal p = cert.getSubjectDN();
                if (p.getName() == null || p.getName().length() <= 0) continue;
                return p;
            }
        }
        return null;
    }

    private static List<X509Certificate> getSslClientCerts(Request request) {
        return (List)request.getAttributes().get(ORG_RESTLET_HTTPS_CLIENT_CERTS);
    }

    public static boolean isSslClientCertAuth(Request request) {
        return SecurityUtil.getSslClientCerts(request) != null;
    }
}

