/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalBeanSetterTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalConstrParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalFieldTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnClassException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.InjectException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingConstructorException;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;
import org.restlet.ext.jaxrs.internal.util.PathRegExp;
import org.restlet.ext.jaxrs.internal.wrappers.PerRequestRootResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.RootResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.SingletonRootResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClasses {
    private final ExtensionBackwardMapping extensionBackwardMapping;
    private final JaxRsProviders jaxRsProviders;
    private final Logger logger;
    private final Map<Class<?>, ResourceClass> resourceClasses = new HashMap();
    private final Set<RootResourceClass> rootResourceClasses = new CopyOnWriteArraySet<RootResourceClass>();
    private final ThreadLocalizedContext tlContext;

    public ResourceClasses(ThreadLocalizedContext tlContext, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, Logger logger) {
        this.tlContext = tlContext;
        this.jaxRsProviders = jaxRsProviders;
        this.extensionBackwardMapping = extensionBackwardMapping;
        this.logger = logger;
    }

    public boolean addRootClass(Class<?> jaxRsClass) {
        RootResourceClass newRrc;
        Class<?> rootResourceClass = jaxRsClass;
        try {
            newRrc = this.getRootClassWrapper(rootResourceClass);
        }
        catch (IllegalParamTypeException e) {
            String msg = "Ignore provider " + rootResourceClass.getName() + ": Could not instantiate class " + rootResourceClass.getName();
            this.logger.log(Level.WARNING, msg, e);
            return false;
        }
        catch (IllegalPathOnClassException e) {
            this.logger.warning("The root resource class " + rootResourceClass.getName() + " is annotated with an illegal path: " + e.getPath() + ". (" + e.getMessage() + ")");
            return false;
        }
        catch (IllegalArgumentException e) {
            this.logger.log(Level.WARNING, "The root resource class " + rootResourceClass.getName() + " is not a valud root resource class: " + e.getMessage(), e);
            return false;
        }
        catch (MissingAnnotationException e) {
            this.logger.log(Level.WARNING, "The root resource class " + rootResourceClass.getName() + " is not a valud root resource class: " + e.getMessage(), e);
            return false;
        }
        catch (MissingConstructorException e) {
            this.logger.warning("The root resource class " + rootResourceClass.getName() + " has no valid constructor");
            return false;
        }
        catch (IllegalConstrParamTypeException e) {
            this.logger.warning("The root resource class " + rootResourceClass.getName() + " has no valid constructor: " + e.getMessage());
            return false;
        }
        catch (IllegalBeanSetterTypeException e) {
            this.logger.warning("The root resource class " + rootResourceClass.getName() + " has no valid constructor: " + e.getMessage());
            return false;
        }
        catch (IllegalFieldTypeException e) {
            this.logger.warning("The root resource class " + rootResourceClass.getName() + " has no valid constructor: " + e.getMessage());
            return false;
        }
        PathRegExp uriTempl = newRrc.getPathRegExp();
        for (RootResourceClass rrc : this.rootResourceClasses) {
            if (rrc.getJaxRsClass().equals(rootResourceClass)) {
                return true;
            }
            if (!rrc.getPathRegExp().equals(uriTempl)) continue;
            this.logger.warning("There is already a root resource class with path " + uriTempl.getPathTemplateEnc());
            return false;
        }
        this.rootResourceClasses.add(newRrc);
        return true;
    }

    public boolean addRootSingleton(Object jaxRsRootObject) {
        jaxRsRootObject.toString();
        throw new NotYetImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceClass getResourceClass(Class<?> jaxRsResourceClass) throws IllegalArgumentException, MissingAnnotationException {
        ResourceClass rc;
        Map<Class<?>, ResourceClass> map = this.resourceClasses;
        synchronized (map) {
            rc = this.resourceClasses.get(jaxRsResourceClass);
        }
        if (rc == null) {
            rc = new ResourceClass(jaxRsResourceClass, this.tlContext, this.jaxRsProviders, this.extensionBackwardMapping, Context.getCurrentLogger());
            map = this.resourceClasses;
            synchronized (map) {
                this.resourceClasses.put(jaxRsResourceClass, rc);
            }
        }
        return rc;
    }

    public RootResourceClass getRootClassWrapper(Class<?> jaxRsRootResourceClass) throws IllegalArgumentException, MissingAnnotationException, IllegalPathOnClassException, MissingConstructorException, IllegalConstrParamTypeException, IllegalFieldTypeException, IllegalBeanSetterTypeException, IllegalPathParamTypeException {
        return new PerRequestRootResourceClass(jaxRsRootResourceClass, this.tlContext, this.jaxRsProviders, this.extensionBackwardMapping, Context.getCurrentLogger());
    }

    public RootResourceClass getRootSingletonWrapper(Object jaxRsRootResourceObject) throws IllegalArgumentException, MissingAnnotationException, IllegalPathOnClassException, MissingConstructorException, IllegalConstrParamTypeException, IllegalFieldTypeException, IllegalBeanSetterTypeException, IllegalPathParamTypeException, InjectException, InvocationTargetException {
        return new SingletonRootResourceClass(jaxRsRootResourceObject, this.tlContext, this.jaxRsProviders, this.extensionBackwardMapping, Context.getCurrentLogger());
    }

    public Iterable<RootResourceClass> roots() {
        return this.rootResourceClasses;
    }
}

