/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import java.util.Map;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringRouter
extends Router {
    public SpringRouter() {
    }

    public SpringRouter(Context context) {
        super(context);
    }

    public SpringRouter(Restlet parent) {
        super(parent.getContext());
    }

    public void setAttachments(Map<String, Object> routes) {
        SpringRouter.setAttachments(this, routes);
    }

    public static void setAttachments(Router router, Map<String, Object> routes) {
        try {
            for (String key : routes.keySet()) {
                Object value = routes.get(key);
                if (value instanceof Restlet) {
                    router.attach(key, (Restlet)value);
                    continue;
                }
                if (value instanceof Class) {
                    router.attach(key, (Class)value);
                    continue;
                }
                if (value instanceof String) {
                    Class<?> resourceClass = Class.forName((String)value);
                    if (Resource.class.isAssignableFrom(resourceClass)) {
                        router.attach(key, resourceClass);
                        continue;
                    }
                    router.getLogger().warning("Unknown class found in the mappings. Only subclasses of org.restlet.resource.Resource are allowed.");
                    continue;
                }
                router.getLogger().warning("Unknown object found in the mappings. Only instances of Restlet and subclasses of org.restlet.resource.Resource are allowed.");
            }
        }
        catch (ClassNotFoundException e) {
            router.getLogger().log(Level.WARNING, "Unable to set the router mappings", e);
        }
    }
}

