/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.velocity;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRepresentation
extends OutputRepresentation {
    private String templateName;
    private VelocityEngine engine = new VelocityEngine();
    private Map<String, Object> dataModel;

    public TemplateRepresentation(String templateName, MediaType mediaType) {
        this(templateName, new TreeMap<String, Object>(), mediaType);
    }

    public TemplateRepresentation(String templateName, Map<String, Object> dataModel, MediaType mediaType) {
        super(mediaType);
        this.dataModel = dataModel;
        this.templateName = templateName;
    }

    public VelocityEngine getEngine() {
        return this.engine;
    }

    public Map<String, Object> getDataModel() {
        return this.dataModel;
    }

    public Map<String, Object> setDataModel(Map<String, Object> dataModel) {
        this.dataModel = dataModel;
        return dataModel;
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedWriter tmplWriter = null;
        try {
            this.getEngine().init();
            VelocityContext context = new VelocityContext(this.getDataModel());
            Template template = this.engine.getTemplate(this.templateName);
            tmplWriter = this.getCharacterSet() != null ? new BufferedWriter(new OutputStreamWriter(outputStream, this.getCharacterSet().getName())) : new BufferedWriter(new OutputStreamWriter(outputStream, template.getEncoding()));
            template.merge((Context)context, (Writer)tmplWriter);
            ((Writer)tmplWriter).flush();
        }
        catch (Exception e) {
            throw new IOException("Template processing error. " + e.getMessage());
        }
    }
}

