/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.FaultInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.util.XmlWriter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseInfo
extends DocumentedInfo {
    private List<FaultInfo> faults;
    private List<ParameterInfo> parameters;
    private List<RepresentationInfo> representations;

    public ResponseInfo() {
    }

    public ResponseInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public ResponseInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public ResponseInfo(String documentation) {
        super(documentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FaultInfo> getFaults() {
        List<FaultInfo> f = this.faults;
        if (f == null) {
            ResponseInfo responseInfo = this;
            synchronized (responseInfo) {
                f = this.faults;
                if (f == null) {
                    this.faults = f = new ArrayList<FaultInfo>();
                }
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            ResponseInfo responseInfo = this;
            synchronized (responseInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepresentationInfo> getRepresentations() {
        List<RepresentationInfo> r = this.representations;
        if (r == null) {
            ResponseInfo responseInfo = this;
            synchronized (responseInfo) {
                r = this.representations;
                if (r == null) {
                    this.representations = r = new ArrayList<RepresentationInfo>();
                }
            }
        }
        return r;
    }

    public void setFaults(List<FaultInfo> faults) {
        this.faults = faults;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setRepresentations(List<RepresentationInfo> representations) {
        this.representations = representations;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        for (RepresentationInfo representationInfo : this.getRepresentations()) {
            representationInfo.updateNamespaces(namespaces);
        }
        for (FaultInfo faultInfo : this.getFaults()) {
            faultInfo.updateNamespaces(namespaces);
        }
        for (ParameterInfo parameterInfo : this.getParameters()) {
            parameterInfo.updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        if (this.getDocumentations().isEmpty() && this.getFaults().isEmpty() && this.getParameters().isEmpty() && this.getRepresentations().isEmpty()) {
            writer.emptyElement("http://research.sun.com/wadl/2006/10", "response");
        } else {
            writer.startElement("http://research.sun.com/wadl/2006/10", "response");
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            for (ParameterInfo parameterInfo : this.getParameters()) {
                parameterInfo.writeElement(writer);
            }
            for (RepresentationInfo representationInfo : this.getRepresentations()) {
                representationInfo.writeElement(writer);
            }
            for (FaultInfo faultInfo : this.getFaults()) {
                faultInfo.writeElement(writer);
            }
            writer.endElement("http://research.sun.com/wadl/2006/10", "response");
        }
    }
}

