/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.RequestInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.wadl.WadlRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlResource
extends Resource {
    private volatile boolean autoDescribed = true;

    public WadlResource() {
    }

    public WadlResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    public boolean allowOptions() {
        return this.isReadable();
    }

    protected Representation describe() {
        return this.describe(this.getPreferredWadlVariant());
    }

    private void describe(ResourceInfo info) {
        this.describe(this.getResourcePath(), info);
    }

    public void describe(String path, ResourceInfo info) {
        info.setPath(path);
        ArrayList methodsList = new ArrayList();
        methodsList.addAll(this.getAllowedMethods());
        Collections.sort(methodsList, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        List<MethodInfo> methods = info.getMethods();
        for (Method method : methodsList) {
            if (!this.isDescribable(method)) continue;
            MethodInfo methodInfo = new MethodInfo();
            this.describeMethod(method, methodInfo);
            methods.add(methodInfo);
        }
        info.setParameters(this.getParametersInfo());
    }

    protected Representation describe(Variant variant) {
        WadlRepresentation result = null;
        if (variant != null) {
            ResourceInfo resourceInfo = new ResourceInfo();
            this.describe(resourceInfo);
            if (MediaType.APPLICATION_WADL_XML.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(resourceInfo);
            } else if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(resourceInfo).getHtmlRepresentation();
            }
        }
        return result;
    }

    protected void describeDelete(MethodInfo info) {
    }

    protected void describeGet(MethodInfo info) {
        for (Variant variant : this.getVariants()) {
            info.addResponseRepresentation(variant);
        }
    }

    protected void describeMethod(Method method, MethodInfo info) {
        info.setName(method);
        info.setRequest(new RequestInfo());
        info.setResponse(new ResponseInfo());
        if (Method.GET.equals((Object)method)) {
            this.describeGet(info);
        } else if (Method.POST.equals((Object)method)) {
            this.describePost(info);
        } else if (Method.PUT.equals((Object)method)) {
            this.describePut(info);
        } else if (Method.DELETE.equals((Object)method)) {
            this.describeDelete(info);
        } else if (Method.OPTIONS.equals((Object)method)) {
            this.describeOptions(info);
        }
    }

    protected void describeOptions(MethodInfo info) {
        for (Variant variant : this.getWadlVariants()) {
            info.addResponseRepresentation(variant);
        }
    }

    protected void describePost(MethodInfo info) {
    }

    protected void describePut(MethodInfo info) {
    }

    protected List<ParameterInfo> getParametersInfo() {
        List<ParameterInfo> result = null;
        return result;
    }

    protected Variant getPreferredWadlVariant() {
        Variant result = null;
        Application app = Application.getCurrent();
        Language language = null;
        if (app != null) {
            language = app.getMetadataService().getDefaultLanguage();
        }
        result = this.getRequest().getClientInfo().getPreferredVariant(this.getWadlVariants(), language);
        return result;
    }

    protected String getResourcePath() {
        Reference ref = new Reference(this.getRequest().getRootRef(), this.getRequest().getResourceRef());
        return ref.getRemainingPart();
    }

    protected Reference getResourcesBase() {
        return this.getRequest().getRootRef();
    }

    protected List<Variant> getWadlVariants() {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.APPLICATION_WADL_XML));
        result.add(new Variant(MediaType.TEXT_HTML));
        return result;
    }

    public void handleOptions() {
        if (this.isAutoDescribed()) {
            this.getResponse().setEntity(this.describe());
        }
    }

    public boolean isAutoDescribed() {
        return this.autoDescribed;
    }

    public boolean isDescribable(Method method) {
        return !Method.HEAD.equals((Object)method) && !Method.OPTIONS.equals((Object)method);
    }

    public void setAutoDescribed(boolean autoDescribed) {
        this.autoDescribed = autoDescribed;
    }
}

