/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.resource.Variant;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepresentationInfo
extends DocumentedInfo {
    private String identifier;
    private MediaType mediaType;
    private List<ParameterInfo> parameters;
    private List<Reference> profiles;
    private List<Status> statuses;
    private String xmlElement;

    public RepresentationInfo() {
    }

    public RepresentationInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public RepresentationInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public RepresentationInfo(MediaType mediaType) {
        this.setMediaType(mediaType);
    }

    public RepresentationInfo(String documentation) {
        super(documentation);
    }

    public RepresentationInfo(Variant variant) {
        this.setMediaType(variant.getMediaType());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            RepresentationInfo representationInfo = this;
            synchronized (representationInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reference> getProfiles() {
        List<Reference> p = this.profiles;
        if (p == null) {
            RepresentationInfo representationInfo = this;
            synchronized (representationInfo) {
                p = this.profiles;
                if (p == null) {
                    this.profiles = p = new ArrayList<Reference>();
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Status> getStatuses() {
        List<Status> s = this.statuses;
        if (s == null) {
            RepresentationInfo representationInfo = this;
            synchronized (representationInfo) {
                s = this.statuses;
                if (s == null) {
                    this.statuses = s = new ArrayList<Status>();
                }
            }
        }
        return s;
    }

    public String getXmlElement() {
        return this.xmlElement;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setProfiles(List<Reference> profiles) {
        this.profiles = profiles;
    }

    public void setStatuses(List<Status> statuses) {
        this.statuses = statuses;
    }

    public void setXmlElement(String xmlElement) {
        this.xmlElement = xmlElement;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        for (ParameterInfo parameterInfo : this.getParameters()) {
            parameterInfo.updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        Iterator<Reference> iterator;
        StringBuilder builder;
        AttributesImpl attributes = new AttributesImpl();
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            attributes.addAttribute("", "id", null, "xs:ID", this.getIdentifier());
        }
        if (this.getMediaType() != null) {
            attributes.addAttribute("", "mediaType", null, "xs:string", this.getMediaType().toString());
        }
        if (this.getProfiles() != null && !this.getProfiles().isEmpty()) {
            builder = new StringBuilder();
            iterator = this.getProfiles().iterator();
            while (iterator.hasNext()) {
                Reference reference = iterator.next();
                builder.append(reference.toString());
                if (!iterator.hasNext()) continue;
                builder.append(" ");
            }
            attributes.addAttribute("", "profile", null, "xs:string", builder.toString());
        }
        if (this.getStatuses() != null && !this.getStatuses().isEmpty()) {
            builder = new StringBuilder();
            iterator = this.getStatuses().iterator();
            while (iterator.hasNext()) {
                Status status = (Status)iterator.next();
                builder.append(status.getCode());
                if (!iterator.hasNext()) continue;
                builder.append(" ");
            }
            attributes.addAttribute("", "status", null, "xs:string", builder.toString());
        }
        if (this.getXmlElement() != null && !this.getXmlElement().equals("")) {
            attributes.addAttribute("", "element", null, "xs:QName", this.getXmlElement());
        }
        if (this.getDocumentations().isEmpty() && this.getParameters().isEmpty()) {
            writer.emptyElement("http://research.sun.com/wadl/2006/10", "representation", null, (Attributes)attributes);
        } else {
            writer.startElement("http://research.sun.com/wadl/2006/10", "representation", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            for (ParameterInfo parameterInfo : this.getParameters()) {
                parameterInfo.writeElement(writer);
            }
            writer.endElement("http://research.sun.com/wadl/2006/10", "representation");
        }
    }
}

