/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInfo
extends DocumentedInfo {
    private List<ResourceInfo> childResources;
    private String identifier;
    private List<MethodInfo> methods;
    private List<ParameterInfo> parameters;
    private String path;
    private MediaType queryType;
    private List<Reference> type;

    public ResourceInfo() {
    }

    public ResourceInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public ResourceInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public ResourceInfo(String documentation) {
        super(documentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceInfo> getChildResources() {
        List<ResourceInfo> r = this.childResources;
        if (r == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                r = this.childResources;
                if (r == null) {
                    this.childResources = r = new ArrayList<ResourceInfo>();
                }
            }
        }
        return r;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MethodInfo> getMethods() {
        List<MethodInfo> m = this.methods;
        if (m == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                m = this.methods;
                if (m == null) {
                    this.methods = m = new ArrayList<MethodInfo>();
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    public String getPath() {
        return this.path;
    }

    public MediaType getQueryType() {
        return this.queryType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reference> getType() {
        List<Reference> t = this.type;
        if (t == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                t = this.type;
                if (t == null) {
                    this.type = t = new ArrayList<Reference>();
                }
            }
        }
        return t;
    }

    public void setChildResources(List<ResourceInfo> resources) {
        this.childResources = resources;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMethods(List<MethodInfo> methods) {
        this.methods = methods;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setQueryType(MediaType queryType) {
        this.queryType = queryType;
    }

    public void setType(List<Reference> type) {
        this.type = type;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        for (ParameterInfo parameterInfo : this.getParameters()) {
            parameterInfo.updateNamespaces(namespaces);
        }
        for (ResourceInfo resourceInfo : this.getChildResources()) {
            resourceInfo.updateNamespaces(namespaces);
        }
        for (MethodInfo methodInfo : this.getMethods()) {
            methodInfo.updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            attributes.addAttribute("", "id", null, "xs:ID", this.getIdentifier());
        }
        if (this.getPath() != null && !this.getPath().equals("")) {
            attributes.addAttribute("", "path", null, "xs:string", this.getPath());
        }
        if (this.getQueryType() != null) {
            attributes.addAttribute("", "queryType", null, "xs:string", this.getQueryType().getMainType());
        }
        if (this.getType() != null && !this.getType().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<Reference> iterator = this.getType().iterator();
            while (iterator.hasNext()) {
                Reference reference = iterator.next();
                builder.append(reference.toString());
                if (!iterator.hasNext()) continue;
                builder.append(" ");
            }
            attributes.addAttribute("", "type", null, "xs:string", builder.toString());
        }
        if (this.getChildResources().isEmpty() && this.getDocumentations().isEmpty() && this.getMethods().isEmpty() && this.getParameters().isEmpty()) {
            writer.emptyElement("http://research.sun.com/wadl/2006/10", "resource", null, (Attributes)attributes);
        } else {
            writer.startElement("http://research.sun.com/wadl/2006/10", "resource", null, (Attributes)attributes);
            for (ResourceInfo resourceInfo : this.getChildResources()) {
                resourceInfo.writeElement(writer);
            }
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            for (MethodInfo methodInfo : this.getMethods()) {
                methodInfo.writeElement(writer);
            }
            for (ParameterInfo parameterInfo : this.getParameters()) {
                parameterInfo.writeElement(writer);
            }
            writer.endElement("http://research.sun.com/wadl/2006/10", "resource");
        }
    }
}

