/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.resource.Representation;
import org.restlet.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Conditions {
    private volatile List<Tag> match;
    private volatile Date modifiedSince;
    private volatile List<Tag> noneMatch;
    private volatile Date unmodifiedSince;

    public List<Tag> getMatch() {
        if (this.match == null) {
            this.match = new ArrayList<Tag>();
        }
        return this.match;
    }

    public Date getModifiedSince() {
        return this.modifiedSince;
    }

    public List<Tag> getNoneMatch() {
        if (this.noneMatch == null) {
            this.noneMatch = new ArrayList<Tag>();
        }
        return this.noneMatch;
    }

    public Status getStatus(Method method, Representation representation) {
        boolean matched;
        Status result = null;
        if (this.match != null && !this.match.isEmpty()) {
            matched = false;
            boolean failed = false;
            boolean all = this.getMatch().get(0).equals(Tag.ALL);
            if (representation != null) {
                if (!all && representation.getTag() != null) {
                    Iterator<Tag> iter = this.getMatch().iterator();
                    while (!matched && iter.hasNext()) {
                        Tag tag = iter.next();
                        matched = tag.equals(representation.getTag(), false);
                    }
                } else {
                    matched = all;
                }
            } else {
                failed = all;
            }
            boolean bl = failed = failed || !matched;
            if (failed) {
                result = Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        if (result == null && this.noneMatch != null && !this.noneMatch.isEmpty()) {
            matched = false;
            if (representation != null) {
                if (representation.getTag() != null) {
                    Iterator<Tag> iter = this.getNoneMatch().iterator();
                    while (!matched && iter.hasNext()) {
                        Tag tag = iter.next();
                        matched = tag.equals(representation.getTag(), Method.GET.equals(method) || Method.HEAD.equals(method));
                    }
                    if (matched) {
                        Date modifiedSince = this.getModifiedSince();
                        boolean isModifiedSince = modifiedSince != null && (DateUtils.after(new Date(), modifiedSince) || representation.getModificationDate() == null || DateUtils.after(modifiedSince, representation.getModificationDate()));
                        matched = !isModifiedSince;
                    }
                }
            } else {
                matched = this.getNoneMatch().get(0).equals(Tag.ALL);
            }
            if (matched) {
                result = Method.GET.equals(method) || Method.HEAD.equals(method) ? Status.REDIRECTION_NOT_MODIFIED : Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        if (result == null && this.getModifiedSince() != null && representation != null) {
            boolean isModifiedSince;
            Date modifiedSince = this.getModifiedSince();
            boolean bl = isModifiedSince = DateUtils.after(new Date(), modifiedSince) || representation.getModificationDate() == null || DateUtils.after(modifiedSince, representation.getModificationDate());
            if (!isModifiedSince) {
                result = Status.REDIRECTION_NOT_MODIFIED;
            }
        }
        if (result == null && this.getUnmodifiedSince() != null && representation != null) {
            boolean isUnModifiedSince;
            Date unModifiedSince = this.getUnmodifiedSince();
            boolean bl = isUnModifiedSince = unModifiedSince == null || representation.getModificationDate() == null || DateUtils.after(representation.getModificationDate(), unModifiedSince);
            if (!isUnModifiedSince) {
                result = Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        return result;
    }

    public Date getUnmodifiedSince() {
        return this.unmodifiedSince;
    }

    public boolean hasSome() {
        return this.match != null && !this.match.isEmpty() || this.noneMatch != null && !this.noneMatch.isEmpty() || this.getModifiedSince() != null || this.getUnmodifiedSince() != null;
    }

    public void setMatch(List<Tag> tags) {
        this.match = tags;
    }

    public void setModifiedSince(Date date) {
        this.modifiedSince = DateUtils.unmodifiable(date);
    }

    public void setNoneMatch(List<Tag> tags) {
        this.noneMatch = tags;
    }

    public void setUnmodifiedSince(Date date) {
        this.unmodifiedSince = DateUtils.unmodifiable(date);
    }
}

