/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.data.Metadata;

public final class Protocol
extends Metadata {
    public static final Protocol SMTP = new Protocol("smtp", "SMTP", "Simple Mail Transfer Protocol", 25);
    public static final Protocol SMTP_STARTTLS = new Protocol("smtp", "SMTP_STARTTLS", "Simple Mail Transfer Protocol (starting a TLS encryption)", 25);
    public static final Protocol SMTPS = new Protocol("smtps", "SMTPS", "Simple Mail Transfer Protocol (Secure)", 465);
    public static final int UNKNOWN_PORT = -1;
    public static final Protocol WAR = new Protocol("war", "WAR", "Web Archive Access Protocol", -1);
    public static final Protocol AJP = new Protocol("ajp", "AJP", "Apache Jakarta Protocol", 8009);
    public static final Protocol ALL = new Protocol("all", "ALL", "Wildcard for all protocols", -1);
    public static final Protocol CLAP = new Protocol("clap", "CLAP", "Class Loader Access Protocol", -1);
    public static final Protocol FILE = new Protocol("file", "FILE", "Local File System Protocol", -1);
    public static final Protocol FTP = new Protocol("ftp", "FTP", "File Transfer Protocol", 21);
    public static final Protocol HTTP = new Protocol("http", "HTTP", "HyperText Transport Protocol", 80);
    public static final Protocol HTTPS = new Protocol("https", "HTTPS", "HyperText Transport Protocol (Secure)", 443);
    public static final Protocol JAR = new Protocol("jar", "JAR", "Java ARchive", -1);
    public static final Protocol JDBC = new Protocol("jdbc", "JDBC", "Java DataBase Connectivity", -1);
    public static final Protocol RIAP = new Protocol("riap", "RIAP", "Restlet Internal Access Protocol", -1);
    private volatile int defaultPort;
    private volatile String schemeName;

    public static Protocol valueOf(String schemeName) {
        Protocol result = null;
        if (schemeName != null) {
            result = schemeName.equalsIgnoreCase(AJP.getSchemeName()) ? AJP : (schemeName.equalsIgnoreCase(CLAP.getSchemeName()) ? CLAP : (schemeName.equalsIgnoreCase(FILE.getSchemeName()) ? FILE : (schemeName.equalsIgnoreCase(FTP.getSchemeName()) ? FTP : (schemeName.equalsIgnoreCase(HTTP.getSchemeName()) ? HTTP : (schemeName.equalsIgnoreCase(HTTPS.getSchemeName()) ? HTTPS : (schemeName.equalsIgnoreCase(JAR.getSchemeName()) ? JAR : (schemeName.equalsIgnoreCase(JDBC.getSchemeName()) ? JDBC : (schemeName.equalsIgnoreCase(RIAP.getSchemeName()) ? RIAP : (schemeName.equalsIgnoreCase(SMTP.getSchemeName()) ? SMTP : (schemeName.equalsIgnoreCase(SMTP_STARTTLS.getSchemeName()) ? SMTP_STARTTLS : (schemeName.equalsIgnoreCase(SMTPS.getSchemeName()) ? SMTPS : (schemeName.equalsIgnoreCase(WAR.getSchemeName()) ? WAR : new Protocol(schemeName)))))))))))));
        }
        return result;
    }

    public Protocol(String schemeName) {
        this(schemeName, schemeName.toUpperCase(), schemeName.toUpperCase() + " Protocol", -1);
    }

    public Protocol(String schemeName, String name, String description, int defaultPort) {
        super(name, description);
        this.schemeName = schemeName;
        this.defaultPort = defaultPort;
    }

    public boolean equals(Object object) {
        return object instanceof Protocol && this.getName().equalsIgnoreCase(((Protocol)object).getName());
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }
}

